/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.internal.MetadataSearchCriteriaBuilder;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IMetadataReference;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectQuery {
    public static Integer NO_CASE = new Integer(0);
    public static Integer UPPER_CASE = new Integer(1);
    public static Integer LOWER_CASE = new Integer(2);
    private RuntimeMetadata metadata;
    private IQuery query;
    private Map criteriaMap;
    private ArrayList columnNames = null;
    private ArrayList columnNamesInSource = null;
    private ArrayList columnTypes = null;
    private ArrayList caseTypes = null;
    private String[] columnNamesArray;
    private String[] columnNamesInSourceArray;
    private Class[] columnTypesArray;
    private Integer[] caseTypeArray;

    public ObjectQuery(RuntimeMetadata metadata, ICommand command) throws ConnectorException {
        ArgCheck.isNotNull(metadata);
        ArgCheck.isNotNull(command);
        this.metadata = metadata;
        this.query = (IQuery)command;
        this.initColumnData();
    }

    public IQuery getQuery() {
        return this.query;
    }

    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    public String getTableNameInSource() throws ConnectorException {
        return this.getMetadataObjectName(this.getGroup());
    }

    private IGroup getGroup() {
        List fromItems = this.query.getFrom().getItems();
        Assertion.assertTrue(fromItems.size() == 1, "Expected only one from item but found " + fromItems.size() + ".");
        IGroup fromGroup = (IGroup)fromItems.get(0);
        return fromGroup;
    }

    public String[] getColumnNames() {
        return this.columnNamesInSourceArray;
    }

    public Class[] getColumnTypes() {
        return this.columnTypesArray;
    }

    private void initColumnData() throws ConnectorException {
        List selectSymbols = this.query.getSelect().getSelectSymbols();
        this.columnNames = new ArrayList(selectSymbols.size());
        this.columnNamesInSource = new ArrayList(selectSymbols.size());
        this.columnTypes = new ArrayList(selectSymbols.size());
        this.caseTypes = new ArrayList(selectSymbols.size());
        Iterator selectIterator = selectSymbols.iterator();
        while (selectIterator.hasNext()) {
            ISelectSymbol symbol = (ISelectSymbol)selectIterator.next();
            this.addColumn(symbol);
        }
        this.columnNamesArray = this.columnNames.toArray(new String[this.columnNames.size()]);
        this.columnNamesInSourceArray = this.columnNamesInSource.toArray(new String[this.columnNamesInSource.size()]);
        this.columnTypesArray = this.columnTypes.toArray(new Class[this.columnTypes.size()]);
        this.caseTypeArray = this.caseTypes.toArray(new Integer[this.caseTypes.size()]);
    }

    public void checkType(int i2, Object value) {
        if (value != null && !this.columnTypesArray[i2].isAssignableFrom(value.getClass())) {
            throw new MetaMatrixRuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Type_mismatch", new Object[]{this.columnNamesArray[i2], this.columnTypesArray[i2].getName(), value.getClass().getName()}));
        }
    }

    public void checkCaseType(int i2, Object value) {
        Integer caseType;
        if (value != null && !(value instanceof String) && !(caseType = this.caseTypeArray[i2]).equals(NO_CASE)) {
            throw new MetaMatrixRuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.CASE_Function", this.columnNamesArray[i2]));
        }
    }

    public Integer getCaseType(int i2) {
        return this.caseTypeArray[i2];
    }

    private void addColumn(ISelectSymbol symbol) throws ConnectorException {
        IElement element = null;
        IExpression expression = symbol.getExpression();
        String functionName = null;
        if (expression instanceof IFunction) {
            IFunction function = (IFunction)expression;
            functionName = function.getName();
            IExpression[] expressions = function.getParameters();
            element = (IElement)expressions[0];
        } else if (expression instanceof IElement) {
            element = (IElement)expression;
        }
        IElement reference = element;
        MetadataID id = reference.getMetadataID();
        MetadataObject obj = this.metadata.getObject(id);
        if (obj != null && obj.getNameInSource() != null) {
            Element elementMetadata = (Element)obj;
            this.columnTypes.add(elementMetadata.getJavaType());
            this.columnNamesInSource.add(obj.getNameInSource());
            this.columnNames.add(obj.getMetadataID().getFullName());
            if (functionName == null) {
                this.caseTypes.add(NO_CASE);
            } else if (functionName.equalsIgnoreCase("UPPER") || functionName.equalsIgnoreCase("UCASE")) {
                this.caseTypes.add(UPPER_CASE);
            } else if (functionName.equalsIgnoreCase("LOWER") || functionName.equalsIgnoreCase("LCASE")) {
                this.caseTypes.add(LOWER_CASE);
            }
        }
    }

    private String getMetadataObjectName(Object element) throws ConnectorException {
        IMetadataReference reference = (IMetadataReference)element;
        MetadataID id = reference.getMetadataID();
        MetadataObject obj = this.metadata.getObject(id);
        if (obj != null && obj.getNameInSource() != null) {
            return obj.getNameInSource();
        }
        throw new MetaMatrixRuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Could_not_resolve_name_for_query___1", new Object[]{this.query.toString()}));
    }

    public Map getCriteria() throws ConnectorException {
        this.initCriteria();
        return this.criteriaMap;
    }

    private void initCriteria() throws ConnectorException {
        if (this.criteriaMap == null) {
            MetadataSearchCriteriaBuilder builder = new MetadataSearchCriteriaBuilder(this);
            this.criteriaMap = builder.getCriteria();
        }
    }

    Object getExpressionValue(IExpression expression) {
        ILiteral literal = null;
        String functionName = null;
        if (expression instanceof IFunction) {
            IFunction function = (IFunction)expression;
            IExpression[] expressions = function.getParameters();
            literal = (ILiteral)expressions[0];
            functionName = function.getName();
        } else if (expression instanceof ILiteral) {
            literal = (ILiteral)expression;
        }
        Object value = literal.getValue();
        if (functionName != null && value != null) {
            if (functionName.equalsIgnoreCase("UPPER") || functionName.equalsIgnoreCase("UCASE")) {
                value = value.toString().toUpperCase();
            } else if (functionName.equalsIgnoreCase("LOWER") || functionName.equalsIgnoreCase("LCASE")) {
                value = value.toString().toLowerCase();
            }
        }
        return value;
    }

    String getElementName(IExpression expression) throws ConnectorException {
        IElement element = null;
        if (expression instanceof IFunction) {
            IFunction function = (IFunction)expression;
            IExpression[] expressions = function.getParameters();
            element = (IElement)expressions[0];
        } else if (expression instanceof IElement) {
            element = (IElement)expression;
        }
        return this.getMetadataObjectName(element);
    }

    String getFunctionName(IExpression expression) throws ConnectorException {
        if (expression instanceof IFunction) {
            IFunction function = (IFunction)expression;
            return function.getName();
        }
        return null;
    }
}

