/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.adapter.ObjectResultsTranslator;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.ObjectProcedure;
import com.metamatrix.connector.metadata.internal.ReflectionWrapper;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectProcedureProcessor {
    private final IObjectSource objectSource;
    private final ObjectResultsTranslator resultsTranslator;
    private ResultSetIterator resultSet;
    static /* synthetic */ Class class$com$metamatrix$common$types$ClobType;
    static /* synthetic */ Class class$com$metamatrix$common$types$BlobType;

    public ObjectProcedureProcessor(IObjectSource objectSource, ObjectResultsTranslator resultsTranslator) {
        this.objectSource = objectSource;
        this.resultsTranslator = resultsTranslator;
    }

    public void process(ObjectProcedure procedure) throws ConnectorException {
        String resultSetNameInSource = procedure.getResultSetNameInSource();
        if (resultSetNameInSource != null) {
            this.resultSet = new ResultSetIterator(resultSetNameInSource, procedure);
        }
    }

    public Iterator getResultSet() {
        return this.resultSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResultSetIterator
    implements Iterator {
        private Iterator results;
        private String resultSetSourceName = null;
        private String resultDefiningMethodName = null;
        private List rows;
        private final ObjectProcedure procedure;

        public ResultSetIterator(String resultSetNameInSource, ObjectProcedure procedure) {
            ArgCheck.isNotNull(resultSetNameInSource);
            ArgCheck.isNotNull(procedure);
            this.procedure = procedure;
            this.initResutSetNameSegements(resultSetNameInSource);
        }

        private void initResutSetNameSegements(String resultSetNameInSource) {
            int endMethodNameIndex;
            ArgCheck.isNotNull(resultSetNameInSource);
            int startMethodNameIndex = resultSetNameInSource.lastIndexOf(String.valueOf('('));
            if (startMethodNameIndex > 0 && (endMethodNameIndex = resultSetNameInSource.lastIndexOf(String.valueOf(')'))) > 0 && endMethodNameIndex > startMethodNameIndex) {
                this.resultDefiningMethodName = resultSetNameInSource.substring(startMethodNameIndex + 1, endMethodNameIndex);
                this.resultSetSourceName = resultSetNameInSource.substring(0, startMethodNameIndex);
            }
            if (this.resultSetSourceName == null) {
                this.resultSetSourceName = resultSetNameInSource;
            }
        }

        private void updateResults() {
            IObjectSource objectSource = ObjectProcedureProcessor.this.objectSource;
            this.results = objectSource.getObjects(this.resultSetSourceName, this.procedure.getCriteria());
        }

        public boolean hasNext() {
            if (this.results == null) {
                this.updateResults();
            }
            return this.results.hasNext();
        }

        public Object next() {
            if (this.results == null) {
                this.updateResults();
            }
            List resultObjects = (List)this.results.next();
            this.rows = new ArrayList(resultObjects.size());
            Iterator iterator = resultObjects.iterator();
            while (iterator.hasNext()) {
                this.createRows(iterator.next());
            }
            return this.rows;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void createRows(Object resultObject) {
            ArgCheck.isNotNull(resultObject);
            ReflectionWrapper wrapper = new ReflectionWrapper(resultObject);
            Map propValues = this.procedure.getPropValues();
            if (propValues != null) {
                Iterator entryIter = propValues.entrySet().iterator();
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    Object key = entry.getKey();
                    Object[] value = new Object[]{entry.getValue()};
                    wrapper.set(key.toString(), value);
                }
            }
            if (this.resultDefiningMethodName == null) {
                this.addRow(wrapper, null);
            } else {
                Collection<Object> subTableCollection = null;
                Object subTableResults = wrapper.get(this.resultDefiningMethodName);
                if (subTableResults.getClass().isArray()) {
                    subTableCollection = Arrays.asList((Object[])subTableResults);
                } else if (subTableResults instanceof Collection) {
                    subTableCollection = (Collection)subTableResults;
                }
                this.createRowsFor(wrapper, subTableCollection);
            }
        }

        private void createRowsFor(ReflectionWrapper wrapperAroundResultObject, Collection subTableCollection) {
            Iterator iterator = subTableCollection.iterator();
            while (iterator.hasNext()) {
                Object subTableObject = iterator.next();
                this.addRow(wrapperAroundResultObject, subTableObject);
            }
        }

        private void addRow(ReflectionWrapper wrapper, Object subTableObject) {
            ArrayList<Object> newRow = new ArrayList<Object>();
            String[] columnNames = this.procedure.getColumnNamesInSource();
            for (int i2 = 0; i2 < columnNames.length; ++i2) {
                Object value = null;
                if (columnNames[i2].equals(this.resultDefiningMethodName)) {
                    value = subTableObject;
                } else if (columnNames[i2].startsWith(this.resultDefiningMethodName + '.')) {
                    ReflectionWrapper subWrapper = new ReflectionWrapper(subTableObject);
                    String columnMethodName = columnNames[i2].substring(this.resultDefiningMethodName.length() + 1);
                    value = subWrapper.get(columnMethodName);
                } else {
                    value = wrapper.get(columnNames[i2]);
                }
                Class type = this.procedure.getResultSetColumnType(i2);
                if (type.equals(class$com$metamatrix$common$types$ClobType == null ? ObjectProcedureProcessor.class$("com.metamatrix.common.types.ClobType") : class$com$metamatrix$common$types$ClobType)) {
                    value = ObjectProcedureProcessor.this.resultsTranslator.translateClob(value);
                } else if (type.equals(class$com$metamatrix$common$types$BlobType == null ? ObjectProcedureProcessor.class$("com.metamatrix.common.types.BlobType") : class$com$metamatrix$common$types$BlobType)) {
                    value = ObjectProcedureProcessor.this.resultsTranslator.translateBlob(value);
                } else {
                    this.procedure.checkType(i2, value);
                }
                newRow.add(value);
            }
            this.rows.add(newRow);
        }
    }
}

