/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.index.MetadataInCriteria;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IndexCriteriaBuilder {
    private static final String RECORD_STRING_SPACE = " ";
    private static final String RECORD_STRING_TRUE = "1";
    private static final String RECORD_STRING_FALSE = "0";

    public static String getMatchPrefix(String indexName, Map criteria) {
        ArgCheck.isNotEmpty(indexName);
        ArgCheck.isNotNull(criteria);
        Map updatedCriteria = IndexCriteriaBuilder.getUpdatedCriteria(indexName, criteria);
        if (criteria.isEmpty()) {
            return IndexCriteriaBuilder.getRecordDefaultMatchPrefix(updatedCriteria);
        }
        if (indexName.equalsIgnoreCase("DATATYPES.INDEX")) {
            return IndexCriteriaBuilder.getDatatypeRecordMatchPrefix(updatedCriteria);
        }
        if (indexName.equalsIgnoreCase("PROPERTIES.INDEX")) {
            return IndexCriteriaBuilder.getPropertiesRecordMatchPrefix(updatedCriteria);
        }
        if (indexName.equalsIgnoreCase("MODELS.INDEX")) {
            return IndexCriteriaBuilder.getModelRecordMatchPrefix(updatedCriteria);
        }
        return IndexCriteriaBuilder.getRecordHeaderMatchPrefix(updatedCriteria);
    }

    public static String getMatchPattern(String indexName, Map criteria) {
        ArgCheck.isNotEmpty(indexName);
        ArgCheck.isNotNull(criteria);
        Map updatedCriteria = IndexCriteriaBuilder.getUpdatedCriteria(indexName, criteria);
        StringBuffer sb = new StringBuffer(100);
        if (criteria.isEmpty()) {
            sb.append(IndexCriteriaBuilder.getRecordDefaultMatchPattern(updatedCriteria));
        } else if (indexName.equalsIgnoreCase("DATATYPES.INDEX")) {
            sb.append(IndexCriteriaBuilder.getDatatypeRecordMatchPattern(updatedCriteria));
        } else if (indexName.equalsIgnoreCase("PROPERTIES.INDEX")) {
            sb.append(IndexCriteriaBuilder.getPropertiesRecordMatchPattern(updatedCriteria));
        } else {
            sb.append(IndexCriteriaBuilder.getRecordHeaderMatchPattern(updatedCriteria));
        }
        sb.append('*');
        return sb.toString();
    }

    private static Map getUpdatedCriteria(String indexName, Map criteria) {
        String record_type;
        HashMap<String, MetadataLiteralCriteria> tmp = new HashMap<String, MetadataLiteralCriteria>(criteria.size());
        if (IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype") == null && (record_type = IndexUtil.getRecordTypeForIndexFileName(indexName)) != null) {
            MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria("Recordtype", record_type);
            tmp.put("Recordtype".toUpperCase(), literalCriteria);
        }
        Iterator iter = criteria.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            tmp.put(key.toUpperCase(), (MetadataLiteralCriteria)value);
        }
        return tmp;
    }

    public static Collection getLiteralCriteria(Map criteria) {
        ArrayList inCriteriaCollect = new ArrayList();
        HashMap criteriaCopy = new HashMap(criteria);
        Iterator iter = criteria.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof MetadataInCriteria)) continue;
            inCriteriaCollect.add(value);
            criteriaCopy.remove(key);
        }
        Collection criteriaCollect = new ArrayList();
        criteriaCollect.add(criteriaCopy);
        Iterator iter2 = inCriteriaCollect.iterator();
        while (iter2.hasNext()) {
            criteriaCollect = IndexCriteriaBuilder.getLiteralCriteria((MetadataInCriteria)iter2.next(), criteriaCollect);
        }
        return criteriaCollect;
    }

    private static Collection getLiteralCriteria(MetadataInCriteria inCriteria, Collection criteriaCollect) {
        ArrayList critCollection = new ArrayList();
        Collection litCriteria = inCriteria.getLiteralCriteria();
        Iterator iter1 = criteriaCollect.iterator();
        while (iter1.hasNext()) {
            Map criteria = (Map)iter1.next();
            Iterator critIter = litCriteria.iterator();
            while (critIter.hasNext()) {
                HashMap copyCriteria = new HashMap(criteria);
                copyCriteria.put(inCriteria.getFieldName().toUpperCase(), critIter.next());
                critCollection.add(copyCriteria);
            }
        }
        return critCollection;
    }

    private static String getRecordDefaultMatchPrefix(Map criteria) {
        String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
        if (IndexCriteriaBuilder.isPrefixCriteriaString(recordTypeCriteria)) {
            StringBuffer sb = new StringBuffer(2);
            sb.append(recordTypeCriteria.toUpperCase());
            sb.append('\u00a0');
            return sb.toString();
        }
        return null;
    }

    private static String getRecordDefaultMatchPattern(Map criteria) {
        StringBuffer sb = new StringBuffer(2);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "Recordtype", sb);
        return sb.toString();
    }

    private static String getRecordHeaderMatchPattern(Map criteria) {
        StringBuffer sb = new StringBuffer(100);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "Recordtype", sb);
        IndexCriteriaBuilder.appendMultiMatchField(sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "UUID", sb);
        String fullNameCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "FullName");
        if (fullNameCriteria == null) {
            String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
            if (recordTypeCriteria != null && recordTypeCriteria.equalsIgnoreCase("A")) {
                IndexCriteriaBuilder.appendCriteriaValue(criteria, "Name", sb);
            } else {
                String modelNameCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "ModelName");
                if (modelNameCriteria != null) {
                    sb.append(modelNameCriteria);
                    sb.append('.');
                }
                sb.append('*');
                String nameCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Name");
                if (nameCriteria != null) {
                    sb.append('.');
                    sb.append(nameCriteria);
                }
                sb.append('\u00a0');
            }
        } else {
            IndexCriteriaBuilder.appendFieldValue(fullNameCriteria, sb);
        }
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "NameInSource", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "ParentUUID", sb);
        return sb.toString();
    }

    private static String getRecordHeaderMatchPrefix(Map criteria) {
        String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
        String fullNameCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "FullName");
        if (IndexCriteriaBuilder.isPrefixCriteriaString(recordTypeCriteria) && IndexCriteriaBuilder.isPrefixCriteriaString(fullNameCriteria)) {
            StringBuffer sb = new StringBuffer(30);
            sb.append(recordTypeCriteria.toUpperCase());
            sb.append('\u00a0');
            sb.append(fullNameCriteria.toUpperCase());
            sb.append('\u00a0');
            return sb.toString();
        }
        return null;
    }

    protected static String getValueInCriteria(Map criteria, String fieldName) {
        Object value;
        if (criteria.containsKey(fieldName = fieldName.toUpperCase()) && criteria.get(fieldName) != null && (value = criteria.get(fieldName)) instanceof MetadataLiteralCriteria) {
            MetadataLiteralCriteria literalCriteria = (MetadataLiteralCriteria)value;
            Object literalValue = literalCriteria.getFieldValue();
            if (literalValue == null) {
                return RECORD_STRING_SPACE;
            }
            if (literalValue instanceof Boolean) {
                Boolean booleanValue = (Boolean)literalValue;
                if (booleanValue.booleanValue()) {
                    return RECORD_STRING_TRUE;
                }
                return RECORD_STRING_FALSE;
            }
            return literalValue.toString();
        }
        return null;
    }

    private static void appendCriteriaValue(Map criteria, String fieldName, StringBuffer sb) {
        String fieldValue = IndexCriteriaBuilder.getValueInCriteria(criteria, fieldName);
        IndexCriteriaBuilder.appendFieldValue(fieldValue, sb);
    }

    private static void appendFieldValue(String fieldValue, StringBuffer sb) {
        if (fieldValue != null) {
            sb.append(fieldValue);
            sb.append('\u00a0');
        } else {
            IndexCriteriaBuilder.appendMultiMatchField(sb);
        }
    }

    private static void appendMultiMatchField(StringBuffer sb) {
        IndexCriteriaBuilder.appendFieldValue(IndexConstants.RECORD_STRING.MATCH_CHAR_STRING, sb);
    }

    private static String getModelRecordMatchPrefix(Map criteria) {
        String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
        String nameCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Name");
        if (IndexCriteriaBuilder.isPrefixCriteriaString(recordTypeCriteria) && IndexCriteriaBuilder.isPrefixCriteriaString(nameCriteria)) {
            StringBuffer sb = new StringBuffer(30);
            sb.append(recordTypeCriteria.toUpperCase());
            sb.append('\u00a0');
            sb.append(nameCriteria.toUpperCase());
            sb.append('\u00a0');
            return sb.toString();
        }
        return null;
    }

    private static String getPropertiesRecordMatchPattern(Map criteria) {
        StringBuffer sb = new StringBuffer(100);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "Recordtype", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "UUID", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "PropertyName", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "PropertyValue", sb);
        return sb.toString();
    }

    private static String getPropertiesRecordMatchPrefix(Map criteria) {
        String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
        String uuidCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "UUID");
        if (IndexCriteriaBuilder.isPrefixCriteriaString(recordTypeCriteria) && IndexCriteriaBuilder.isPrefixCriteriaString(uuidCriteria)) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(recordTypeCriteria.toUpperCase());
            sb.append('\u00a0');
            sb.append(uuidCriteria.toLowerCase());
            sb.append('\u00a0');
            return sb.toString();
        }
        return null;
    }

    private static String getDatatypeRecordMatchPattern(Map criteria) {
        StringBuffer sb = new StringBuffer(100);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "Recordtype", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "DatatypeID", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "BasetypeID", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "Name", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "UUID", sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "NameInSource", sb);
        IndexCriteriaBuilder.appendMultiMatchField(sb);
        IndexCriteriaBuilder.appendMultiMatchField(sb);
        IndexCriteriaBuilder.appendCriteriaValue(criteria, "RuntimeTypeName", sb);
        return sb.toString();
    }

    private static String getDatatypeRecordMatchPrefix(Map criteria) {
        String recordTypeCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "Recordtype");
        String uuidCriteria = IndexCriteriaBuilder.getValueInCriteria(criteria, "DatatypeID");
        if (IndexCriteriaBuilder.isPrefixCriteriaString(recordTypeCriteria) && IndexCriteriaBuilder.isPrefixCriteriaString(uuidCriteria)) {
            StringBuffer sb = new StringBuffer(100);
            sb.append(recordTypeCriteria.toUpperCase());
            sb.append('\u00a0');
            sb.append(uuidCriteria.toLowerCase());
            sb.append('\u00a0');
            return sb.toString();
        }
        return null;
    }

    private static boolean isPrefixCriteriaString(String criteria) {
        boolean prefixCriteria = true;
        if (StringUtil.isEmpty(criteria)) {
            prefixCriteria = false;
        } else if (criteria.indexOf(42) != -1) {
            prefixCriteria = false;
        } else if (criteria.indexOf(63) != -1) {
            prefixCriteria = false;
        }
        return prefixCriteria;
    }
}

