/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.connector.metadata.IndexFile;
import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.MultiObjectSource;
import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.connector.metadata.adapter.ObjectConnector;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.ISimpleObjectSource;
import com.metamatrix.connector.metadata.internal.ObjectSourceAdapter;
import com.metamatrix.connector.sysadmin.extension.ISysAdminConnectionFactory;
import com.metamatrix.connector.sysadmin.extension.ISysAdminSource;
import com.metamatrix.connector.sysadmin.util.SysAdminUtil;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.dqp.datamgr.InternalConnectorEnvironment;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.modeler.core.index.IndexSelector;

public class IndexConnector
extends ObjectConnector {
    private final String propertyFilePath;
    private ISimpleObjectSource propertyFileObjectSource = null;
    private ISysAdminConnectionFactory adminFactory = null;

    public IndexConnector() {
        this("com/metamatrix/connector/metadata/enum/");
    }

    public IndexConnector(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
        this.propertyFileObjectSource = new PropertyFileObjectSource(this.propertyFilePath);
    }

    public void initialize(ConnectorEnvironment environment) throws ConnectorException {
        super.initialize(environment);
        String isServerVM = VMNaming.getVMName();
        if (isServerVM != null && isServerVM.length() > 0) {
            this.adminFactory = SysAdminUtil.createFactory(environment, this.getClass().getClassLoader());
        }
    }

    protected IObjectSource getMetadataObjectSource(SecurityContext context) throws ConnectorException {
        InternalConnectorEnvironment internalEnvironment = (InternalConnectorEnvironment)((Object)this.getEnvironment());
        IndexSelectorSource metadataService = (IndexSelectorSource)internalEnvironment.findResource("dqp.metadata");
        IndexSelector indexSelector = null;
        try {
            indexSelector = metadataService.getIndexSelector(context.getVirtualDatabaseName(), context.getVirtualDatabaseVersion());
        }
        catch (MetaMatrixComponentException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        if (indexSelector == null) {
            throw new ConnectorException(MetadataConnectorPlugin.Util.getString("IndexConnector.indexSelector_not_available"));
        }
        IndexFile indexFile = new IndexFile(indexSelector, context.getVirtualDatabaseName(), context.getVirtualDatabaseVersion(), (VDBService)internalEnvironment.findResource("dqp.vdb"));
        MultiObjectSource multiObjectSource = new MultiObjectSource(indexFile, ".properties", this.propertyFileObjectSource);
        return new ObjectSourceAdapter(multiObjectSource);
    }

    protected ISysAdminSource getSysAdminObjectSource(SecurityContext context) throws ConnectorException {
        if (this.adminFactory == null) {
            throw new ConnectorException(MetadataConnectorPlugin.Util.getString("IndexConnector.SysAdmin_feature_not_available"));
        }
        return this.adminFactory.getObjectSource(context);
    }
}

