/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml;

import com.metamatrix.core.util.StringUtil;
import org.jdom.Verifier;

public class XmlUtil {
    private XmlUtil() {
    }

    public static String containsValidCharacters(String str) {
        return Verifier.checkCharacterData(str);
    }

    public static String removeInvalidCharacters(String str) {
        if (str != null) {
            char[] orig = str.toCharArray();
            int origLength = orig.length;
            StringBuffer sb = new StringBuffer(str.length());
            for (int i2 = 0; i2 != origLength; ++i2) {
                char c2 = orig[i2];
                if (!Verifier.isXMLCharacter(c2)) continue;
                sb.append(c2);
            }
            return sb.toString();
        }
        return str;
    }

    public static String escapeCharacterData(String text) {
        if (text == null) {
            return null;
        }
        String escaped = StringUtil.replace(text, "&", "&amp;");
        escaped = StringUtil.replace(escaped, ">", "&gt;");
        escaped = StringUtil.replace(escaped, "<", "&lt;");
        escaped = StringUtil.replace(escaped, "\"", "&quot;");
        escaped = StringUtil.replace(escaped, "'", "&apos;");
        return escaped;
    }
}

