/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos.xaresource;

import com.atomikos.datasource.xa.XID;
import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.atomikos.xaresource.Constants;
import com.metamatrix.common.xa.atomikos.xaresource.MMXid;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XALogAdministrator
implements LogAdministrator {
    private LogControl control_;

    public void registerLogControl(LogControl control) {
        LogManager.logDetail("XA_TXN", new Object[]{"LogControl registered:", control});
        this.control_ = control;
    }

    public void deregisterLogControl(LogControl control) {
        this.control_ = null;
        LogManager.logDetail("XA_TXN", "LogControl deregistered");
    }

    protected Xid[] recover() throws XAException {
        if (this.control_ == null) {
            throw new XAException(-7);
        }
        ArrayList<XID> xids = new ArrayList<XID>();
        AdminTransaction[] adminTrans = this.control_.getAdminTransactions();
        for (int i2 = 0; i2 < adminTrans.length; ++i2) {
            String tid;
            int splitterIndex;
            int state = adminTrans[i2].getState();
            if (state != 2 && state != 1 && state != 3 && state != 4 && state != 0 || (splitterIndex = (tid = adminTrans[i2].getTid()).indexOf(Constants.TID_SEPERATOR)) == -1) continue;
            String globalPart = tid.substring(0, splitterIndex);
            String branchPart = tid.substring(splitterIndex + 1);
            xids.add(new XID(globalPart, branchPart));
        }
        Xid[] result = new Xid[xids.size()];
        for (int i3 = 0; i3 < xids.size(); ++i3) {
            Xid xid = (Xid)xids.get(i3);
            result[i3] = new MMXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        }
        return result;
    }

    protected void forget(Xid xid) throws XAException {
        if (this.control_ == null) {
            throw new XAException(-7);
        }
        StringBuffer tid = new StringBuffer();
        tid.append(new String(xid.getGlobalTransactionId()));
        tid.append(Constants.TID_SEPERATOR);
        tid.append(new String(xid.getBranchQualifier()));
        String[] tids = new String[]{tid.toString()};
        AdminTransaction[] adminTrans = this.control_.getAdminTransactions(tids);
        if (adminTrans.length > 0) {
            adminTrans[0].forceForget();
        }
    }

    protected boolean rollback(Xid xid) throws XAException {
        boolean succeeded = false;
        if (this.control_ == null) {
            throw new XAException(-7);
        }
        StringBuffer tid = new StringBuffer();
        tid.append(new String(xid.getGlobalTransactionId()));
        tid.append(Constants.TID_SEPERATOR);
        tid.append(new String(xid.getBranchQualifier()));
        String[] tids = new String[]{tid.toString()};
        AdminTransaction[] adminTrans = this.control_.getAdminTransactions(tids);
        if (adminTrans.length > 0) {
            try {
                adminTrans[0].forceRollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
            succeeded = true;
        }
        return succeeded;
    }
}

