/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos;

import com.atomikos.icatch.jta.UserTransactionServer;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.MMUserTransactionServer;
import java.rmi.RemoteException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class UserTransactionServerWrapper
implements MMUserTransactionServer {
    private static final String CTX = "XA_TXN";
    private UserTransactionServer uts;
    private int defaultTimeout;

    public UserTransactionServerWrapper(UserTransactionServer uts, int defaultTimeout) {
        this.uts = uts;
        this.defaultTimeout = defaultTimeout;
    }

    public String begin(int timeout) throws SystemException, NotSupportedException {
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.begin(" + timeout + ")");
        String tid = "?";
        try {
            if (timeout == 0) {
                timeout = this.defaultTimeout;
            }
            tid = this.uts.begin(timeout);
        }
        catch (RemoteException e2) {
            throw new SystemException(CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_communicate_with_transaction_manager") + e2.getMessage());
        }
        catch (SystemException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_begin_transaction"));
            throw err;
        }
        catch (NotSupportedException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_begin_transaction"));
            throw err;
        }
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.begin(" + timeout + "): TID: " + tid);
        return tid;
    }

    public void commit(String tid) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.commit(" + tid + ")");
        try {
            this.uts.commit(tid);
        }
        catch (RemoteException e2) {
            throw new SystemException(CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_communicate_with_transaction_manager") + e2.getMessage());
        }
        catch (RollbackException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (HeuristicMixedException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (HeuristicRollbackException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (SecurityException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (IllegalStateException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (SystemException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_commit_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
    }

    public void rollback(String tid) throws IllegalStateException, SecurityException, SystemException {
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.rollback(" + tid + ")");
        try {
            this.uts.rollback(tid);
        }
        catch (RemoteException e2) {
            throw new SystemException(CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_communicate_with_transaction_manager") + e2.getMessage());
        }
        catch (IllegalStateException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_rollback_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (SecurityException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_rollback_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (SystemException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_rollback_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
    }

    public void setRollbackOnly(String tid) throws IllegalStateException, SystemException {
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.setRollbackOnly(" + tid + ")");
        try {
            this.uts.setRollbackOnly(tid);
        }
        catch (RemoteException e2) {
            throw new SystemException(CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_communicate_with_transaction_manager") + e2.getMessage());
        }
        catch (IllegalStateException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_set_rollbackOnly_on_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
        catch (SystemException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_set_rollbackOnly_on_transaction_{0}.", new Object[]{tid}));
            throw err;
        }
    }

    public int getStatus(String tid) throws SystemException {
        LogManager.logDetail(CTX, "UserTransactionServerWrapper.getStatus(" + tid + ")");
        try {
            return this.uts.getStatus(tid);
        }
        catch (RemoteException e2) {
            throw new SystemException(CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_communicate_with_transaction_manager") + e2.getMessage());
        }
        catch (SystemException err) {
            LogManager.logError(CTX, (Throwable)err, CommonXAPlugin.Util.getString("UserTransactionServerWrapper.Unable_to_get_transaction_status_{0}.", new Object[]{tid}));
            throw err;
        }
    }
}

