/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.cipher;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class SerializableEncryptor
implements Encryptor,
Serializable {
    private static final String DEFAULT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private transient Key encryptKey;
    private transient Cipher encryptCipher;
    private byte[] encodedKey;
    private String algorithm;
    private String providerName;

    public SerializableEncryptor() {
    }

    public SerializableEncryptor(Key encryptKey) throws CryptoException {
        this.encryptKey = encryptKey;
        this.encodedKey = encryptKey.getEncoded();
        this.algorithm = encryptKey.getAlgorithm();
        if (this.encodedKey == null) {
            throw new CryptoException("Encodedkey was null");
        }
    }

    public SerializableEncryptor(Key encryptKey, String providerName) throws CryptoException {
        this(encryptKey);
        this.providerName = providerName;
    }

    public synchronized byte[] encrypt(byte[] cleartext) throws CryptoException {
        if (this.encryptCipher == null) {
            this.initCipher();
        }
        try {
            return this.encryptCipher.doFinal(cleartext);
        }
        catch (Exception e2) {
            throw new CryptoException("ERR.003.030.0081", CommonPlugin.Util.getString("ERR.003.030.0081", e2.getMessage()));
        }
    }

    public char[] encrypt(char[] cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException("ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0072"));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException("ERR.003.030.0073", CommonPlugin.Util.getString("ERR.003.030.0073"));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        return CryptoFactory.encodeBytes(cipherBytes);
    }

    private void initCipher() throws CryptoException {
        try {
            KeyFactory keyFactory = null;
            if (this.encryptKey == null) {
                keyFactory = this.providerName != null ? KeyFactory.getInstance(this.algorithm, this.providerName) : KeyFactory.getInstance(this.algorithm);
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(this.encodedKey);
                this.encryptKey = keyFactory.generatePublic(publicKeySpec);
            }
            this.encryptCipher = this.providerName != null ? Cipher.getInstance(DEFAULT_ALGORITHM, this.providerName) : Cipher.getInstance(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new CryptoException((Throwable)e2, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", DEFAULT_ALGORITHM));
        }
        catch (NoSuchPaddingException e3) {
            throw new CryptoException((Throwable)e3, "ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0077", DEFAULT_ALGORITHM, e3.getMessage()));
        }
        catch (Throwable e4) {
            e4.printStackTrace();
            throw new CryptoException(e4, "ERR.003.030.0082", CommonPlugin.Util.getString("ERR.003.030.0082", e4.getClass().getName(), DEFAULT_ALGORITHM));
        }
        try {
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (InvalidKeyException e5) {
            throw new CryptoException((Throwable)e5, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", e5.getMessage()));
        }
        catch (Throwable e6) {
            e6.printStackTrace();
            throw new CryptoException(e6, "ERR.003.030.0083", CommonPlugin.Util.getString("ERR.003.030.0083", new Object[]{e6.getClass().getName(), this.encryptCipher, new Integer(1), this.encryptKey}));
        }
    }

    static {
        CryptoUtil.initJCEProvider();
    }
}

