/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;

class Base64ByteEncoder {
    Base64ByteEncoder() {
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i2 = 0; i2 < raw.length; i2 += 3) {
            encoded.append(Base64ByteEncoder.encodeBlock(raw, i2));
        }
        return encoded.toString();
    }

    public static byte[] decode(String base64) {
        if (base64.length() % 4 != 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0059", base64, new Integer(base64.length())));
        }
        int pad = 0;
        if (base64.length() > 0) {
            int i2 = base64.length() - 1;
            while (base64.charAt(i2) == '=') {
                ++pad;
                --i2;
            }
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        for (int i3 = 0; i3 < base64.length(); i3 += 4) {
            int block = (Base64ByteEncoder.getValue(base64.charAt(i3)) << 18) + (Base64ByteEncoder.getValue(base64.charAt(i3 + 1)) << 12) + (Base64ByteEncoder.getValue(base64.charAt(i3 + 2)) << 6) + Base64ByteEncoder.getValue(base64.charAt(i3 + 3));
            for (int j2 = 0; j2 < 3 && rawIndex + j2 < raw.length; ++j2) {
                raw[rawIndex + j2] = (byte)(block >> 8 * (2 - j2) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i2 = 0; i2 <= end; ++i2) {
            int b2 = raw[offset + i2];
            int neuter = b2 < 0 ? b2 + 256 : b2;
            block += neuter << 8 * (2 - i2);
        }
        char[] base64 = new char[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            int sixbit = block >>> 6 * (3 - i3) & 0x3F;
            base64[i3] = Base64ByteEncoder.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    protected static int getValue(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 - 65;
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return c2 - 97 + 26;
        }
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48 + 52;
        }
        if (c2 == '+') {
            return 62;
        }
        if (c2 == '/') {
            return 63;
        }
        if (c2 == '=') {
            return 0;
        }
        return -1;
    }
}

