/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.CommonPlugin;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Permutation {
    private Object[] items;

    public Permutation(Object[] items) {
        if (items == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0027"));
        }
        this.items = items;
    }

    public Iterator generate() {
        return new PermutationIterator(this.items, this.items.length);
    }

    public Iterator generate(int size) {
        if (size > this.items.length) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0028"));
        }
        if (size < 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.030.0029"));
        }
        return new PermutationIterator(this.items, size);
    }

    private static class PermutationIterator
    implements Iterator {
        private Object[] items;
        private int k;
        private int n;
        private int[] j;
        private boolean more = true;
        private int[] last;

        private PermutationIterator(Object[] items, int k2) {
            this.items = items;
            this.k = k2;
            this.n = items.length;
            if (this.n == 0 || k2 == 0) {
                this.more = false;
            } else {
                this.j = new int[this.n];
                this.j[0] = -1;
                this.last = new int[this.n];
                for (int i2 = this.n - 1; i2 >= 0; --i2) {
                    this.last[this.n - 1 - i2] = i2;
                }
            }
        }

        public boolean hasNext() {
            return this.more;
        }

        public Object next() {
            int t2;
            int i2;
            if (!this.more) {
                throw new NoSuchElementException(CommonPlugin.Util.getString("ERR.003.030.0030"));
            }
            if (this.j[0] < 0) {
                for (i2 = 0; i2 < this.n; ++i2) {
                    this.j[i2] = i2;
                }
                int start = this.k;
                int end = this.n - 1;
                while (start < end) {
                    t2 = this.j[start];
                    this.j[start++] = this.j[end];
                    this.j[end--] = t2;
                }
            } else {
                for (i2 = this.n - 2; i2 >= 0 && this.j[i2] >= this.j[i2 + 1]; --i2) {
                }
                if (i2 >= 0) {
                    int least = i2 + 1;
                    for (int m2 = i2 + 2; m2 < this.n; ++m2) {
                        if (this.j[m2] >= this.j[least] || this.j[m2] <= this.j[i2]) continue;
                        least = m2;
                    }
                    t2 = this.j[i2];
                    this.j[i2] = this.j[least];
                    this.j[least] = t2;
                    if (this.k - 1 > i2) {
                        int start = i2 + 1;
                        int end = this.n - 1;
                        while (start < end) {
                            t2 = this.j[start];
                            this.j[start++] = this.j[end];
                            this.j[end--] = t2;
                        }
                        start = this.k;
                        end = this.n - 1;
                        while (start < end) {
                            t2 = this.j[start];
                            this.j[start++] = this.j[end];
                            this.j[end--] = t2;
                        }
                    }
                }
            }
            this.more = false;
            for (int x2 = 0; x2 < this.n; ++x2) {
                if (this.j[x2] == this.last[x2]) continue;
                this.more = true;
            }
            return this.getPermutation(this.j);
        }

        private Object[] getPermutation(int[] index) {
            Object[] perm = new Object[this.k];
            for (int i2 = 0; i2 < this.k; ++i2) {
                perm[i2] = this.items[index[i2]];
            }
            return perm;
        }

        public void remove() {
            throw new UnsupportedOperationException(CommonPlugin.Util.getString("ERR.003.030.0031"));
        }
    }
}

