/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class PasswordMaskUtil {
    public static final String[] PASSWORD_PROP_SUFFIXES = new String[]{"password", "Password"};
    public static final String MASK_STRING = "*****";
    private Properties properties;

    public PasswordMaskUtil(Properties propertiesWithPassword) {
        this.properties = propertiesWithPassword;
    }

    public String toString() {
        int max = this.properties.size() - 1;
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> it = this.properties.entrySet().iterator();
        buf.append("{");
        String key = null;
        for (int i2 = 0; i2 <= max; ++i2) {
            Map.Entry<Object, Object> e2 = it.next();
            key = (String)e2.getKey();
            if (PasswordMaskUtil.doesNameEndWithPasswordSuffix(key)) {
                buf.append(key + "=" + MASK_STRING);
            } else {
                buf.append(key + "=" + e2.getValue());
            }
            if (i2 >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public static boolean doesNameEndWithPasswordSuffix(String propName) {
        for (int i2 = 0; i2 < PASSWORD_PROP_SUFFIXES.length; ++i2) {
            if (!propName.endsWith(PASSWORD_PROP_SUFFIXES[i2])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.setProperty("prop1", "value1");
        props.setProperty("prop2", "value2");
        props.setProperty("prop3", "value3");
        props.setProperty("prop4", "value4");
        props.setProperty("prop5", "value5");
        props.setProperty("password", "mm");
        props.setProperty("Password", "mm2");
        props.setProperty("metamatrix.auth.password", "metamatrix");
        props.setProperty("metamatrix.config.Password", "mmatrix");
        System.out.println("Normal toString: " + props);
        PasswordMaskUtil test = new PasswordMaskUtil(props);
        System.out.println("mask toString: " + test);
    }
}

