/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.util;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.util.CollectorVisitor;
import com.metamatrix.common.tree.util.TreeNodeVisitor;
import com.metamatrix.common.util.I18nArgCheck;

public class CollectorByTypeNameVisitor
extends CollectorVisitor
implements TreeNodeVisitor {
    private final String typeName;

    public CollectorByTypeNameVisitor(String typeName) {
        I18nArgCheck.isNotNull(typeName, "ERR.003.028.0059");
        I18nArgCheck.isNotZeroLength(typeName, "ERR.003.028.0060");
        this.typeName = typeName;
    }

    public void visit(TreeNode node) {
        if (node != null && node.getType() != null && node.getType().getName() != null && this.typeName.equalsIgnoreCase(node.getType().getName())) {
            super.addToCollector(node);
        }
    }
}

