/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.directory.FileSystemRoot;
import com.metamatrix.common.tree.directory.FileSystemViewHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;

class UnixFileSystemView
extends FileSystemViewHelper {
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    private static final String newFolderString = "NewFolder";
    private static final String newFolderNextString = "NewFolder.{0}";
    private static Method listRootsMethod = null;
    private static boolean listRootsMethodChecked = false;
    static /* synthetic */ Class class$java$io$File;

    UnixFileSystemView() {
    }

    public boolean isRoot(File f2) {
        String path = f2.getAbsolutePath();
        return path.length() == 1 && path.charAt(0) == '/';
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0054"));
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i2 = 1; newFolder.exists() && i2 < 100; ++i2) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i2)));
        }
        if (newFolder.exists()) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0055", newFolder.getAbsolutePath()));
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public boolean isHiddenFile(File f2) {
        if (f2 != null) {
            String filename = f2.getName();
            return filename.charAt(0) == '.';
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getRoots() {
        if (!listRootsMethodChecked) {
            try {
                listRootsMethod = (class$java$io$File == null ? (class$java$io$File = UnixFileSystemView.class$("java.io.File")) : class$java$io$File).getMethod("listRoots", noArgTypes);
            }
            catch (NoSuchMethodException e2) {
            }
            finally {
                listRootsMethodChecked = true;
            }
        }
        if (listRootsMethod != null) {
            try {
                File[] roots = (File[])listRootsMethod.invoke(null, noArgs);
                for (int i2 = 0; i2 < roots.length; ++i2) {
                    roots[i2] = new FileSystemRoot(roots[i2]);
                }
                return roots;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        } else {
            File[] roots = new File[]{new File("/")};
            if (roots[0].exists() && roots[0].isDirectory()) {
                return roots;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

