/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeException;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryEditor;
import com.metamatrix.common.tree.directory.EmptyUserTransaction;
import com.metamatrix.common.tree.directory.FileDefinition;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.common.tree.directory.FolderDefinition;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FileSystemEntryEditor
implements DirectoryEntryEditor {
    private FileSystemView view;

    protected FileSystemEntryEditor(FileSystemView view) {
        Assertion.isNotNull(view, "The FileSystemView reference may not be null");
        this.view = view;
    }

    protected FileSystemView getView() {
        return this.view;
    }

    protected TreeNode getActualParent(TreeNode possibleParent) {
        if (possibleParent != null) {
            return possibleParent;
        }
        if (this.getView().getRoots().size() == 0) {
            return this.getView().getHome();
        }
        throw new AssertionException("ERR.003.028.0051", CommonPlugin.Util.getString("ERR.003.028.0051"));
    }

    public void setMarked(TreeNode entry, boolean marked) {
        Assertion.isNotNull(entry, "The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        fsEntry.setMarked(marked);
    }

    public boolean isMarked(TreeNode entry) {
        Assertion.isNotNull(entry, "The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        return fsEntry.isMarked();
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        Assertion.isNotNull(parent, "The TreeNode reference for the parent may not be null");
        Assertion.isNotNull(child, "The TreeNode reference for the child may not be null");
        FileSystemEntry parentEntry = this.assertFileSystemEntry(parent);
        FileSystemEntry childEntry = this.assertFileSystemEntry(child);
        File parentFile = childEntry.getFile().getParentFile();
        return parentEntry.getFile().equals(parentFile);
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        Assertion.isNotNull(ancestor, "The TreeNode reference for the ancestor may not be null");
        Assertion.isNotNull(descendent, "The TreeNode reference for the descendent may not be null");
        FileSystemEntry ancestorEntry = this.assertFileSystemEntry(ancestor);
        FileSystemEntry descendentEntry = this.assertFileSystemEntry(descendent);
        for (File descendentFile = descendentEntry.getFile().getParentFile(); descendentFile != null; descendentFile = descendentFile.getParentFile()) {
            if (!ancestorEntry.getFile().equals(descendentFile)) continue;
            return true;
        }
        return false;
    }

    public TreeNode create(TreeNode parent, ObjectDefinition type) {
        Assertion.isNotNull(parent, "The TreeNode reference may not be null");
        Assertion.isNotNull(type, "The ObjectDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(this.getActualParent(parent));
        this.assertDescendentOfRoot(parent);
        if (type instanceof FolderDefinition) {
            try {
                String namePrefix;
                String newName = namePrefix = this.getNewFolderName();
                int counter = 0;
                while (fsEntry.hasChildWithName(newName)) {
                    newName = namePrefix + ++counter;
                }
                return this.createNewEntry(fsEntry, newName, DirectoryEntry.TYPE_FOLDER);
            }
            catch (TreeNodeException e2) {
            }
            catch (IOException e3) {}
        } else if (type instanceof FileDefinition) {
            try {
                String namePrefix;
                String newName = namePrefix = this.getNewFileName();
                int counter = 0;
                while (fsEntry.hasChildWithName(newName)) {
                    newName = namePrefix + ++counter;
                }
                return this.createNewEntry(fsEntry, newName, DirectoryEntry.TYPE_FILE);
            }
            catch (TreeNodeException e4) {
            }
            catch (IOException e5) {
                // empty catch block
            }
        }
        return null;
    }

    public TreeNode create(TreeNode parent, String name, ObjectDefinition type) {
        block8: {
            Assertion.isNotNull(parent, "The TreeNode reference may not be null");
            Assertion.isNotNull(name, "The name may not be null");
            Assertion.isNotZeroLength(name, "The name may not be zero-length");
            Assertion.isNotNull(type, "The ObjectDefinition reference may not be null");
            FileSystemEntry fsEntry = this.assertFileSystemEntry(this.getActualParent(parent));
            this.assertDescendentOfRoot(parent);
            if (type instanceof FolderDefinition) {
                try {
                    return this.createNewEntry(fsEntry, name, DirectoryEntry.TYPE_FOLDER);
                }
                catch (TreeNodeException e2) {
                    break block8;
                }
                catch (IOException e3) {
                    break block8;
                }
            }
            if (type instanceof FileDefinition) {
                try {
                    return this.createNewEntry(fsEntry, name, DirectoryEntry.TYPE_FILE);
                }
                catch (TreeNodeException e4) {
                }
                catch (IOException e5) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean makeExist(DirectoryEntry entry) {
        Assertion.isNotNull(entry, "The DirectoryEntry reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(entry);
        if (fsEntry.exists()) {
            return false;
        }
        boolean result = false;
        ObjectDefinition type = entry.getType();
        File entryFile = fsEntry.getFile();
        try {
            result = type == DirectoryEntry.TYPE_FOLDER ? entryFile.mkdirs() : entryFile.createNewFile();
        }
        catch (Exception e2) {
            result = false;
        }
        return result;
    }

    public boolean delete(TreeNode node) {
        Assertion.isNotNull(node, "The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        return fsEntry.getFile().delete();
    }

    public TreeNode paste(TreeNode original, TreeNode newParent, boolean deepCopy) {
        Assertion.isNotNull(original, "The TreeNode reference for the orginal node may not be null");
        Assertion.isNotNull(newParent, "The TreeNode reference may not be null");
        this.assertFileSystemEntry(original);
        this.assertFileSystemEntry(this.getActualParent(newParent));
        this.assertDescendentOfRoot(newParent);
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public boolean move(TreeNode node, TreeNode newParent) {
        Assertion.isNotNull(node, "The TreeNode reference may not be null");
        Assertion.isNotNull(newParent, "The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        FileSystemEntry parentEntry = this.assertFileSystemEntry(this.getActualParent(newParent));
        this.assertDescendentOfRoot(newParent);
        if (!parentEntry.getFile().isDirectory()) {
            return false;
        }
        File originalFile = fsEntry.getFile();
        boolean isValid = fsEntry.move(parentEntry);
        if (isValid) {
            this.view.entryMoved(originalFile, fsEntry);
        }
        return isValid;
    }

    public boolean move(TreeNode node, TreeNode newParent, int indexInNewParent) {
        return this.move(node, newParent);
    }

    public boolean moveChild(TreeNode child, int newIndex) {
        Assertion.isNotNull(child, "The TreeNode reference may not be null");
        this.assertFileSystemEntry(child);
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public TreeNode copy(TreeNode node, TreeNode newParent) {
        Assertion.isNotNull(node, "The TreeNode reference may not be null");
        Assertion.isNotNull(newParent, "The TreeNode reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        FileSystemEntry parentEntry = this.assertFileSystemEntry(this.getActualParent(newParent));
        Assertion.assertTrue(fsEntry.exists(), "The FileSystemEntry \"" + fsEntry.getFullName() + "\" must exist on the file system");
        Assertion.assertTrue(parentEntry.exists(), "The FileSystemEntry \"" + parentEntry.getFullName() + "\" must exist on the file system");
        this.assertDescendentOfRoot(newParent);
        if (!parentEntry.getFile().isDirectory()) {
            return null;
        }
        FileSystemEntry theCopy = (FileSystemEntry)fsEntry.copy(parentEntry);
        if (theCopy != null) {
            theCopy = this.view.getFileSystemEntry(theCopy.getFile(), theCopy.getType());
        }
        return theCopy;
    }

    public boolean rename(TreeNode node, String newName) {
        Assertion.isNotNull(node, "The TreeNode reference may not be null");
        Assertion.isNotNull(newName, "The name may not be null");
        Assertion.isNotZeroLength(newName, "The name may not be zero-length");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(node);
        return fsEntry.renameTo(newName);
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getPropertyDefinitions();
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        return def.getAllowedValues();
    }

    public PropertyDefinition getNamePropertyDefinition(TreeNode obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getNamePropertyDefinition();
    }

    public PropertyDefinition getDescriptionPropertyDefinition(TreeNode obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getDescriptionPropertyDefinition();
    }

    public boolean isNameValid(String newName) {
        return FileUtils.isFilenameValid(newName);
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.getValue(def);
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isValidValue(def, value);
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        fsEntry.setValue(def, value);
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public PropertyAccessPolicy getPolicy() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public boolean isReadOnly(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isReadOnly();
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(obj);
        return fsEntry.isReadOnly();
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        Assertion.isNotNull(def, "The PropertyDefinition reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public void reset(PropertiedObject obj) {
        Assertion.isNotNull(obj, "The PropertiedObject reference may not be null");
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public UserTransaction createReadTransaction() {
        return new EmptyUserTransaction(null);
    }

    public UserTransaction createWriteTransaction() {
        return new EmptyUserTransaction(null);
    }

    public UserTransaction createWriteTransaction(Object source) {
        return new EmptyUserTransaction(source);
    }

    protected FileSystemEntry assertFileSystemEntry(TreeNode obj) {
        Assertion.assertTrue(obj instanceof FileSystemEntry, "The type of TreeNode entry must be a FileSystemEntry");
        FileSystemEntry entry = (FileSystemEntry)obj;
        return entry;
    }

    protected FileSystemEntry assertFileSystemEntry(PropertiedObject obj) {
        Assertion.assertTrue(obj instanceof FileSystemEntry, "The type of PropertiedObject entry must be a FileSystemEntry");
        FileSystemEntry entry = (FileSystemEntry)obj;
        return entry;
    }

    protected void assertDescendentOfRoot(TreeNode descendent) {
        if (this.getView().isRoot(descendent)) {
            return;
        }
        Iterator itr = this.getView().getActualRoots().iterator();
        while (itr.hasNext()) {
            TreeNode root = (TreeNode)itr.next();
            if (!this.isAncestorOf(root, descendent)) continue;
            return;
        }
        throw new AssertionException("ERR.003.028.0053", CommonPlugin.Util.getString("ERR.003.028.0053"));
    }

    private TreeNode createNewEntry(TreeNode parent, String name, ObjectDefinition type) throws IOException, TreeNodeException {
        Assertion.isNotNull(parent, "The TreeNode reference may not be null");
        Assertion.isNotNull(name, "The name may not be null");
        Assertion.isNotZeroLength(name, "The name may not be zero-length");
        Assertion.isNotNull(type, "The ObjectDefinition reference may not be null");
        Assertion.assertTrue(type instanceof FileDefinition || type instanceof FolderDefinition, "The ObjectDefinition must be of type FileDefinition or FolderDefinition");
        FileSystemEntry fsEntry = this.assertFileSystemEntry(parent);
        File parentFile = fsEntry.getFile();
        File file = new File(parentFile, name);
        return this.view.getFileSystemEntry(file, type);
    }

    protected String getNewFolderName() {
        return "New Folder";
    }

    protected String getNewFileName() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0052"));
    }

    public static void main(String[] args) {
        System.out.println("Creating FileSystemEntryEditor instance ...");
        String rootPath = "E:\\products\\common\\current\\src\\com\\metamatrix\\common\\tree";
        FileSystemView view = new FileSystemView(new File(rootPath), true);
        FileSystemEntryEditor editor = (FileSystemEntryEditor)view.getDirectoryEntryEditor();
        System.out.println("\nCreating FileSystemEntry instance ...");
        String name = "testFile.out";
        String path = "E:\\products\\common\\current\\src\\com\\metamatrix\\common\\tree";
        String fullName = path + File.separator + name;
        FileSystemEntry parent = view.getFileSystemEntry(new File(path), DirectoryEntry.TYPE_FOLDER);
        FileSystemEntry entry = view.getFileSystemEntry(new File(fullName), DirectoryEntry.TYPE_FILE);
        if (!entry.exists()) {
            entry = (FileSystemEntry)editor.create(parent, name, DirectoryEntry.TYPE_FILE);
        }
        System.out.println("\nCreated FileSystemEntry instance ...");
        System.out.println("   name = " + entry.getName());
        System.out.println("   path = " + entry.getFile().getAbsolutePath());
        System.out.println("\nCreating FileSystemEntry instance ...");
        String badPath = "E:\\products\\metadata\\current\\src";
        FileSystemEntry badParent = view.getFileSystemEntry(new File(badPath), DirectoryEntry.TYPE_FOLDER);
        entry = (FileSystemEntry)editor.create(badParent, name, DirectoryEntry.TYPE_FILE);
        System.out.println("\nCreated FileSystemEntry instance ...");
        System.out.println("   name = " + entry.getName());
        System.out.println("   path = " + entry.getFile().getAbsolutePath());
        System.out.println("\nRenaming FileSystemEntry instance to ...");
        String newName = "testFile2.out";
        editor.rename(entry, newName);
        System.out.println("   name = " + entry.getName());
        System.out.println("   path = " + entry.getFile().getAbsolutePath());
        System.out.println("\nRenaming FileSystemEntry instance to ...");
        editor.rename(entry, name);
        System.out.println("   name = " + entry.getName());
        System.out.println("   path = " + entry.getFile().getAbsolutePath());
        System.out.println("\nDeleting FileSystemEntry instance ...");
        System.out.println("   name = " + entry.getName());
        System.out.println("   path = " + entry.getFile().getAbsolutePath());
        editor.rename(entry, name);
    }
}

