/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.basic;

import com.metamatrix.common.object.DefaultPropertyAccessPolicy;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.common.transaction.manager.SimpleUserTransactionFactory;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeSource;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.common.tree.basic.BasicTreeNodeEditor;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.util.Assertion;
import java.util.List;

public class BasicTreeNodeSource
implements TreeNodeSource {
    private static UserTransactionFactory DEFAULT_TXN_FACTORY = new SimpleUserTransactionFactory();
    private ObjectIDFactory idFactory;
    private PropertyAccessPolicy policy;
    private UserTransactionFactory txnFactory;

    public BasicTreeNodeSource(ObjectIDFactory idFactory) {
        this(idFactory, new DefaultPropertyAccessPolicy(), DEFAULT_TXN_FACTORY);
    }

    public BasicTreeNodeSource(ObjectIDFactory idFactory, UserTransactionFactory txnFactory) {
        this(idFactory, new DefaultPropertyAccessPolicy(), txnFactory);
    }

    public BasicTreeNodeSource(ObjectIDFactory idFactory, PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        Assertion.isNotNull(idFactory, "The ObjectIDFactory reference may not be null");
        Assertion.isNotNull(policy, "The PropertyAccessPolicy reference may not be null");
        Assertion.isNotNull(txnFactory, "The UserTransactionFactory reference may not be null");
        this.idFactory = idFactory;
        this.policy = policy;
        this.txnFactory = txnFactory;
    }

    protected BasicTreeNode assertBasicTreeNode(TreeNode node) {
        Assertion.isNotNull(node, "The TreeNode reference may not be null");
        Assertion.assertTrue(node instanceof BasicTreeNode, "The referenced object is not an BasicTreeNode");
        BasicTreeNode basicNode = (BasicTreeNode)node;
        return basicNode;
    }

    public List getChildren(TreeNode parent) {
        BasicTreeNode parentNode = this.assertBasicTreeNode(parent);
        return parentNode.getChildren();
    }

    public TreeNode getParent(TreeNode node) {
        BasicTreeNode basicNode = this.assertBasicTreeNode(node);
        return basicNode.getParent();
    }

    public TreeNodeEditor createTreeNodeEditor() {
        return new BasicTreeNodeEditor(this.idFactory, this.policy, this.txnFactory);
    }

    public boolean allowsChildren(TreeNode node) {
        this.assertBasicTreeNode(node);
        return true;
    }

    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        this.assertBasicTreeNode(parent);
        this.assertBasicTreeNode(potentialChild);
        return true;
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        BasicTreeNode parentNode = this.assertBasicTreeNode(parent);
        BasicTreeNode childNode = this.assertBasicTreeNode(child);
        return parentNode.isParentOf(childNode);
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        BasicTreeNode ancestorNode = this.assertBasicTreeNode(ancestor);
        this.assertBasicTreeNode(descendent);
        return ancestorNode.isAncestorOf(descendent);
    }

    public boolean isReadOnly(TreeNode node) {
        this.assertBasicTreeNode(node);
        return false;
    }

    public ObjectIDFactory getObjectIDFactory() {
        return this.idFactory;
    }

    public PropertyAccessPolicy getPropertyAccessPolicy() {
        return this.policy;
    }

    public UserTransactionFactory getUserTransactionFactory() {
        return this.txnFactory;
    }
}

