/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.common.util.I18nArgCheck;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BasicTreeNodeIterator
implements Iterator {
    private List startingNodes;
    private BasicTreeNode last;
    private BasicTreeNode next;

    public BasicTreeNodeIterator(List startingNodes) {
        I18nArgCheck.isNotNull(startingNodes, "ERR.003.028.0011");
        this.startingNodes = startingNodes;
        this.next = this.startingNodes.size() != 0 ? (BasicTreeNode)this.startingNodes.get(0) : null;
        this.last = null;
    }

    public BasicTreeNodeIterator(BasicTreeNode startingNode) {
        I18nArgCheck.isNotNull(startingNode, "ERR.003.028.0001");
        this.startingNodes = new ArrayList(1);
        this.startingNodes.add(startingNode);
        this.next = startingNode;
        this.last = null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextPreOrder(false);
    }

    protected Object nextPreOrder(boolean skipChildren) {
        if (this.next != null) {
            List children;
            this.last = this.next;
            if (!skipChildren && (children = this.last.getChildren()) != null && children.size() != 0) {
                this.next = (BasicTreeNode)children.get(0);
                return this.last;
            }
            this.next = this.getNextSibling(this.last);
            if (this.next != null) {
                return this.last;
            }
            BasicTreeNode node = this.last;
            while (!this.isStartingNode(node) && (node = node.getParent()) != null) {
                this.next = this.getNextSibling(node);
                if (this.next == null) continue;
                return this.last;
            }
            this.next = null;
            return this.last;
        }
        throw new NoSuchElementException(CommonPlugin.Util.getString("ERR.003.028.0027"));
    }

    public void remove() {
        throw new UnsupportedOperationException(CommonPlugin.Util.getString("ERR.003.028.0028"));
    }

    protected boolean isStartingNode(BasicTreeNode node) {
        return this.startingNodes.contains(node);
    }

    protected BasicTreeNode getNextSibling(BasicTreeNode node) {
        List siblings;
        int indexOfNode;
        int indexOfNext;
        if (this.startingNodes.contains(node)) {
            int indexOfNode2 = this.startingNodes.indexOf(node);
            int indexOfNext2 = indexOfNode2 + 1;
            if (indexOfNext2 != this.startingNodes.size()) {
                return (BasicTreeNode)this.startingNodes.get(indexOfNext2);
            }
            return null;
        }
        BasicTreeNode parent = node.getParent();
        if (parent != null && (indexOfNext = (indexOfNode = (siblings = parent.getChildren()).indexOf(node)) + 1) != siblings.size()) {
            return (BasicTreeNode)siblings.get(indexOfNext);
        }
        return null;
    }
}

