/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeComparator;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.util.exception.AssertionException;

public class TreeNodeNameComparator
implements TreeNodeComparator {
    private static final boolean DEFAULT_IGNORE_CASE = false;
    private boolean ignoreCase;

    public TreeNodeNameComparator(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public TreeNodeNameComparator() {
        this(false);
    }

    public void setTreeNodeEditor(TreeNodeEditor editor) {
        if (editor == null) {
            throw new AssertionException(CommonPlugin.Util.getString("ERR.003.028.0014"));
        }
    }

    public int compare(Object obj1, Object obj2) {
        TreeNode entity1 = (TreeNode)obj1;
        TreeNode entity2 = (TreeNode)obj2;
        if (entity1 == null && entity2 == null) {
            return 0;
        }
        if (entity1 != null && entity2 == null) {
            return 1;
        }
        if (entity1 == null && entity2 != null) {
            return -1;
        }
        int result = 0;
        result = this.ignoreCase ? entity1.getName().compareToIgnoreCase(entity2.getName()) : entity1.getName().compareTo(entity2.getName());
        return result;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }
}

