/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.util.I18nArgCheck;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TreeNodeIterator
implements Iterator {
    private List startingNodes;
    private TreeView view;
    private TreeNode last;
    private TreeNode next;

    public TreeNodeIterator(List startingNodes, TreeView view) {
        I18nArgCheck.isNotNull(startingNodes, "ERR.003.028.0011");
        I18nArgCheck.isNotNull(view, "ERR.003.028.0002");
        this.startingNodes = startingNodes;
        this.view = view;
        this.next = this.startingNodes.size() != 0 ? (TreeNode)this.startingNodes.get(0) : null;
        this.last = null;
    }

    public TreeNodeIterator(TreeNode startingNode, TreeView view) {
        I18nArgCheck.isNotNull(startingNode, "ERR.003.028.0001");
        I18nArgCheck.isNotNull(view, "ERR.003.028.0002");
        this.startingNodes = new ArrayList(1);
        this.startingNodes.add(startingNode);
        this.view = view;
        this.next = startingNode;
        this.last = null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextPreOrder(false);
    }

    protected Object nextPreOrder(boolean skipChildren) {
        if (this.next != null) {
            List children;
            this.last = this.next;
            if (!skipChildren && (children = this.view.getChildren(this.last)) != null && children.size() != 0) {
                this.next = (TreeNode)children.get(0);
                return this.last;
            }
            this.next = this.getNextSibling(this.last);
            if (this.next != null) {
                return this.last;
            }
            TreeNode node = this.last;
            while (!this.isStartingNode(node) && (node = this.view.getParent(node)) != null) {
                this.next = this.getNextSibling(node);
                if (this.next == null) continue;
                return this.last;
            }
            this.next = null;
            return this.last;
        }
        throw new NoSuchElementException(CommonPlugin.Util.getString("ERR.003.028.0012"));
    }

    public void remove() {
        throw new UnsupportedOperationException(CommonPlugin.Util.getString("ERR.003.028.0013"));
    }

    protected boolean isStartingNode(TreeNode node) {
        return this.startingNodes.contains(node);
    }

    protected TreeNode getNextSibling(TreeNode node) {
        List siblings;
        int indexOfNode;
        int indexOfNext;
        if (this.startingNodes.contains(node)) {
            int indexOfNode2 = this.startingNodes.indexOf(node);
            int indexOfNext2 = indexOfNode2 + 1;
            if (indexOfNext2 != this.startingNodes.size()) {
                return (TreeNode)this.startingNodes.get(indexOfNext2);
            }
            return null;
        }
        TreeNode parent = this.view.getParent(node);
        if (parent != null && (indexOfNext = (indexOfNode = (siblings = this.view.getChildren(parent)).indexOf(node)) + 1) != siblings.size()) {
            return (TreeNode)siblings.get(indexOfNext);
        }
        return null;
    }
}

