/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.AbstractTreeView;
import com.metamatrix.common.tree.ChildRules;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.util.I18nArgCheck;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.util.Assertion;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuledTreeViewImpl
extends AbstractTreeView
implements TreeView {
    private List roots = null;
    private TreeView tree = null;
    private ChildRules rules = null;

    public RuledTreeViewImpl(TreeView tree, ChildRules rules) {
        I18nArgCheck.isNotNull(tree, "ERR.003.028.0002");
        I18nArgCheck.isNotNull(rules, "ERR.003.028.0003");
        this.tree = tree;
        this.rules = rules;
        this.roots = null;
    }

    public RuledTreeViewImpl(TreeView tree, TreeNode root, ChildRules rules) {
        I18nArgCheck.isNotNull(tree, "ERR.003.028.0002");
        I18nArgCheck.isNotNull(tree, "ERR.003.028.0002");
        I18nArgCheck.isNotNull(rules, "ERR.003.028.0003");
        boolean found = false;
        Iterator iter = tree.getRoots().iterator();
        while (iter.hasNext()) {
            TreeNode treeRoot = (TreeNode)iter.next();
            if (!tree.isAncestorOf(treeRoot, root)) continue;
            found = true;
            break;
        }
        Assertion.assertTrue(found, "The TreeNode must reference a node contained by the TreeView");
        this.tree = tree;
        this.rules = rules;
        this.roots = new ArrayList(1);
        this.roots.add(root);
    }

    protected TreeView getTreeView() {
        return this.tree;
    }

    public PropertiedObjectEditor getPropertiedObjectEditor() {
        return this.tree.getPropertiedObjectEditor();
    }

    public List getPropertyDefinitions() {
        throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.028.0004"));
    }

    public List getRoots() {
        List results;
        List theRoots = this.roots;
        if (theRoots == null) {
            theRoots = this.tree.getRoots();
        }
        if ((results = this.getUnhiddenNodes(theRoots)).size() != 0) {
            return results;
        }
        ArrayList modResults = new ArrayList(results);
        Iterator iter = theRoots.iterator();
        while (iter.hasNext()) {
            modResults.addAll(this.tree.getChildren((TreeNode)iter.next()));
        }
        return this.getUnhiddenNodes(modResults);
    }

    protected void setViewRoots(List roots) {
        this.roots = roots == null || roots.isEmpty() ? null : roots;
    }

    protected List getUnhiddenNodes(List nodes) {
        if (nodes == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TreeNode> removeNodes = null;
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            if (!this.isNodeHidden(node)) continue;
            if (removeNodes == null) {
                removeNodes = new ArrayList<TreeNode>(nodes.size());
            }
            removeNodes.add(node);
        }
        if (removeNodes == null) {
            return nodes;
        }
        ArrayList results = new ArrayList(nodes.size());
        results.addAll(nodes);
        results.removeAll(removeNodes);
        return Collections.unmodifiableList(results);
    }

    protected Set getUnhiddenNodes(Set nodes) {
        if (nodes == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<TreeNode> removeNodes = null;
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            TreeNode node = (TreeNode)iter.next();
            if (!this.isNodeHidden(node)) continue;
            if (removeNodes == null) {
                removeNodes = new ArrayList<TreeNode>(nodes.size());
            }
            removeNodes.add(node);
        }
        if (removeNodes == null) {
            return nodes;
        }
        HashSet results = new HashSet(7);
        results.addAll(nodes);
        results.removeAll(removeNodes);
        return Collections.unmodifiableSet(results);
    }

    public boolean isHidden(TreeNode node) {
        if (node == null) {
            throw new AssertionException(CommonPlugin.Util.getString("ERR.003.028.0001"));
        }
        return this.isNodeHidden(node);
    }

    protected boolean isNodeHidden(TreeNode node) {
        if (this.rules.isHidden(node.getType())) {
            return true;
        }
        return !super.getFilter().accept(node);
    }

    public boolean isMarked(TreeNode node) {
        I18nArgCheck.isNotNull(node, "ERR.003.028.0001");
        return this.tree.isMarked(node);
    }

    public void setMarked(TreeNode node, boolean markedState) {
        I18nArgCheck.isNotNull(node, "ERR.003.028.0001");
        this.tree.setMarked(node, markedState);
    }

    public Set getMarked() {
        return this.getUnhiddenNodes(this.tree.getMarked());
    }

    public TreeNode getHome() {
        return this.tree.getHome();
    }

    public String getPath(TreeNode node) {
        return this.tree.getPath(node);
    }

    public char getSeparatorChar() {
        return this.tree.getSeparatorChar();
    }

    public String getSeparator() {
        return this.tree.getSeparator();
    }

    public TreeNode getParent(TreeNode node) {
        if (this.roots != null && this.roots.contains(node)) {
            return null;
        }
        return this.tree.getParent(node);
    }

    public boolean allowsChildren(TreeNode entry) {
        I18nArgCheck.isNotNull(entry, "ERR.003.028.0001");
        return this.rules.getAllowsChildren(entry.getType());
    }

    public boolean allowsChild(TreeNode parent, TreeNode potentialChild) {
        I18nArgCheck.isNotNull(parent, "ERR.003.028.0005");
        I18nArgCheck.isNotNull(potentialChild, "ERR.003.028.0006");
        return this.rules.getAllowsChild(parent.getType(), potentialChild.getType());
    }

    public List getChildren(TreeNode parent) {
        I18nArgCheck.isNotNull(parent, "ERR.003.028.0001");
        return this.getUnhiddenNodes(this.tree.getChildren(parent));
    }

    public boolean isParentOf(TreeNode parent, TreeNode child) {
        I18nArgCheck.isNotNull(parent, "ERR.003.028.0005");
        I18nArgCheck.isNotNull(child, "ERR.003.028.0007");
        if (this.roots != null && this.roots.contains(child)) {
            return false;
        }
        return this.tree.isParentOf(parent, child);
    }

    public boolean isAncestorOf(TreeNode ancestor, TreeNode descendent) {
        I18nArgCheck.isNotNull(ancestor, "ERR.003.028.0008");
        I18nArgCheck.isNotNull(descendent, "ERR.003.028.0009");
        if (this.roots != null && this.roots.contains(descendent)) {
            return false;
        }
        return this.tree.isAncestorOf(ancestor, descendent);
    }

    public TreeNodeEditor getTreeNodeEditor() {
        return this.tree.getTreeNodeEditor();
    }

    public UserTransaction createReadTransaction() {
        return this.tree.createReadTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return this.tree.createWriteTransaction();
    }

    public UserTransaction createWriteTransaction(Object source) {
        return this.tree.createWriteTransaction(source);
    }

    public Iterator iterator() {
        return new TreeNodeIterator(this.getRoots(), (TreeView)this);
    }

    public Iterator iterator(TreeNode startingPoint) {
        I18nArgCheck.isNotNull(startingPoint, "ERR.003.028.0001");
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }

    protected ChildRules getChildRules() {
        return this.rules;
    }

    public void print(PrintStream stream) {
        if (stream == null) {
            throw new AssertionException("ERR.003.028.0010", CommonPlugin.Util.getString("ERR.003.028.0010"));
        }
        stream.println("ProxyTreeViewImpl");
        Iterator iter = this.getRoots().iterator();
        while (iter.hasNext()) {
            this.print((TreeNode)iter.next(), stream, "  ");
        }
    }

    private void print(TreeNode node, PrintStream stream, String leadingString) {
        if (this.isNodeHidden(node)) {
            return;
        }
        stream.println(leadingString + node.getName());
        Iterator iter = this.getChildren(node).iterator();
        while (iter.hasNext()) {
            this.print((TreeNode)iter.next(), stream, leadingString + "  ");
        }
    }
}

