/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.tree.PassThroughTreeNodeFilter;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.TreeNodeFilter;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeNodePathComparator;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.util.I18nArgCheck;
import com.metamatrix.common.util.exception.AssertionException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTreeView
implements TreeView {
    private static TreeNodeFilter DEFAULT_FILTER = new PassThroughTreeNodeFilter();
    private static Comparator DEFAULT_COMPARATOR = new TreeNodePathComparator();
    private TreeNodeFilter filter = DEFAULT_FILTER;
    private Comparator comparator = DEFAULT_COMPARATOR;

    public void setFilter(TreeNodeFilter filter) {
        this.filter = filter == null ? DEFAULT_FILTER : filter;
    }

    public TreeNodeFilter getFilter() {
        return this.filter;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator == null ? DEFAULT_COMPARATOR : comparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public abstract List getPropertyDefinitions();

    public abstract List getRoots();

    public boolean isRoot(TreeNode node) {
        if (node == null) {
            throw new AssertionException(CommonPlugin.Util.getString("ERR.003.028.0001"));
        }
        return this.getRoots().contains(node);
    }

    public abstract boolean isHidden(TreeNode var1);

    public abstract boolean isMarked(TreeNode var1);

    public abstract TreeNode getHome();

    public abstract String getPath(TreeNode var1);

    public abstract char getSeparatorChar();

    public abstract String getSeparator();

    public abstract TreeNode getParent(TreeNode var1);

    public abstract List getChildren(TreeNode var1);

    public abstract boolean isParentOf(TreeNode var1, TreeNode var2);

    public abstract boolean isAncestorOf(TreeNode var1, TreeNode var2);

    public abstract PropertiedObjectEditor getPropertiedObjectEditor();

    public abstract TreeNodeEditor getTreeNodeEditor();

    public abstract UserTransaction createReadTransaction();

    public abstract UserTransaction createWriteTransaction();

    public abstract UserTransaction createWriteTransaction(Object var1);

    public Iterator iterator() {
        return new TreeNodeIterator(this.getRoots(), (TreeView)this);
    }

    public Iterator iterator(TreeNode startingPoint) {
        I18nArgCheck.isNotNull(startingPoint, "ERR.003.028.0001");
        return new TreeNodeIterator(startingPoint, (TreeView)this);
    }
}

