/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.properties;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.properties.AbstractMultiValuedProperty;
import com.metamatrix.common.properties.MultiValuedProperties;
import com.metamatrix.common.properties.MultiValuedProperty;
import com.metamatrix.common.properties.OrderedMultiValuedProperty;
import com.metamatrix.common.properties.UnorderedMultiValuedProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BasicMultiValuedProperties
implements Serializable,
MultiValuedProperties {
    private Map map;

    public BasicMultiValuedProperties() {
        this.map = new Hashtable();
    }

    public BasicMultiValuedProperties(MultiValuedProperties obj) {
        this.map = new Hashtable();
        AbstractMultiValuedProperty prop = null;
        Set propertyNames = obj.getPropertyNames();
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Collection values = obj.getPropertyValues(name);
            prop = obj.isPropertyOrdered(name) ? new OrderedMultiValuedProperty(name, values) : new UnorderedMultiValuedProperty(name, values);
            this.map.put(prop.getName(), prop);
        }
    }

    public BasicMultiValuedProperties(Set properties) {
        if (properties == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.021.0003"));
        }
        this.map = new Hashtable();
        try {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                MultiValuedProperty prop = (MultiValuedProperty)iter.next();
                this.map.put(prop.getName(), prop);
            }
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.021.0004"));
        }
    }

    public Set getPropertyNames() {
        return this.map.keySet();
    }

    public Collection getPropertyValues(String name) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        return mvp != null ? mvp.getValues() : null;
    }

    public boolean containsPropertyValue(String name, String value) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        return mvp != null && mvp.containsValue(value);
    }

    public int getPropertySize(String name) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        return mvp != null ? mvp.size() : 0;
    }

    public void clearPropertyValues(String name) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        if (mvp != null) {
            mvp.clear();
        }
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isPropertyOrdered(String name) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        return mvp.isOrdered();
    }

    public Collection setProperty(String name, String value) {
        UnorderedMultiValuedProperty mvp = new UnorderedMultiValuedProperty(name, value);
        MultiValuedProperty old = this.map.put(mvp.getName(), mvp);
        return old != null ? old.getValues() : null;
    }

    public Collection setProperty(String name, Collection values) {
        UnorderedMultiValuedProperty mvp = new UnorderedMultiValuedProperty(name, values);
        MultiValuedProperty old = this.map.put(mvp.getName(), mvp);
        return old != null ? old.getValues() : null;
    }

    public Collection setProperty(String name, Collection values, boolean ordered) {
        AbstractMultiValuedProperty mvp = null;
        mvp = ordered ? new OrderedMultiValuedProperty(name, values) : new UnorderedMultiValuedProperty(name, values);
        MultiValuedProperty old = this.map.put(mvp.getName(), mvp);
        return old != null ? old.getValues() : null;
    }

    public void add(MultiValuedProperties obj) {
        if (obj == null) {
            return;
        }
        Set propertyNames = obj.getPropertyNames();
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Collection values = obj.getPropertyValues(name);
            MultiValuedProperty prop = (MultiValuedProperty)this.map.get(name);
            if (prop != null) {
                Iterator iter2 = values.iterator();
                while (iter2.hasNext()) {
                    prop.add((String)iter2.next());
                }
                continue;
            }
            prop = obj.isPropertyOrdered(name) ? new OrderedMultiValuedProperty(name, values) : new UnorderedMultiValuedProperty(name, values);
            this.map.put(prop.getName(), prop);
        }
    }

    public void add(String name, String value) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        if (mvp == null) {
            this.setProperty(name, value);
        } else {
            mvp.add(value);
        }
    }

    public void add(String name, Collection values, boolean ordered) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        if (mvp == null) {
            this.setProperty(name, values, ordered);
        } else {
            mvp.add(values);
        }
    }

    public void add(String name, Collection values) {
        this.add(name, values, false);
    }

    public String remove(String name, int index) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        String result = null;
        if (mvp != null) {
            result = mvp.remove(index);
        }
        return result;
    }

    public boolean remove(String name, String value) {
        MultiValuedProperty mvp = (MultiValuedProperty)this.map.get(name);
        boolean result = false;
        if (mvp != null) {
            result = mvp.remove(value);
        }
        return result;
    }

    public boolean remove(String name) {
        boolean removed = false;
        if (name != null) {
            removed = this.map.remove(name) != null;
        }
        return removed;
    }

    public boolean remove(Set propertyNames) {
        boolean removed = false;
        if (propertyNames != null) {
            Iterator iter = propertyNames.iterator();
            while (iter.hasNext()) {
                Object removedPropValues = this.map.remove(iter.next().toString());
                if (removed || removedPropValues == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    public Object clone() {
        return new BasicMultiValuedProperties(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.getPropertyNames().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            String propName = (String)iter.next();
            sb.append(propName);
            sb.append(":{");
            Iterator valueIter = this.getPropertyValues(propName).iterator();
            if (valueIter.hasNext()) {
                sb.append('\"');
                sb.append(valueIter.next().toString());
                sb.append('\"');
            }
            while (valueIter.hasNext()) {
                sb.append(",\"");
                sb.append(valueIter.next().toString());
                sb.append('\"');
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        BasicMultiValuedProperties props = new BasicMultiValuedProperties();
        props.add("Property.A", "Value1");
        props.add("Property.A", "Value2");
        props.add("Property.A", "Value1");
        props.add("Property.B", "Valuex");
        System.out.println("props -> " + ((Object)props).toString());
        System.out.println("props -> " + props.clone().toString());
        UnorderedMultiValuedProperty mvp1 = new UnorderedMultiValuedProperty("Property.A");
        mvp1.add("Value1");
        mvp1.add("Value2");
        System.out.println("mvp1 -> " + ((Object)mvp1).toString());
        mvp1.set(0, "Value1");
        System.out.println("mvp1 -> " + ((Object)mvp1).toString());
        System.out.println("\n");
        OrderedMultiValuedProperty mvp2 = new OrderedMultiValuedProperty("Property.B");
        mvp2.add("Value1");
        mvp2.add("Value2");
        mvp2.add("Value1");
        System.out.println("mvp2 -> " + ((Object)mvp2).toString());
        mvp2.set(2, "Value1");
        System.out.println("mvp2 -> " + ((Object)mvp2).toString());
        System.out.println("\n");
        OrderedMultiValuedProperty mvp1a = new OrderedMultiValuedProperty("Property.A");
        mvp1a.add("Value1");
        mvp1a.add("Value2");
        mvp1a.add("Value1");
        System.out.println("mvp1a-> " + ((Object)mvp1a).toString());
    }
}

