/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.passthru;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class PassThruJDBCConnectionResource
implements Resource,
Connection {
    private JDBCPlatform platform;
    private String checkedOutBy;
    private Connection conn;

    public PassThruJDBCConnectionResource(Connection conn, JDBCPlatform jdbcPlatform) {
        this.conn = conn;
        this.platform = jdbcPlatform;
    }

    public void init(String checkedOutBy) throws ResourcePoolException {
        this.checkedOutBy = checkedOutBy;
        this.checkIsResourceAlive();
    }

    public JDBCPlatform getPlatform() {
        return this.platform;
    }

    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    public void closeResource() throws ResourcePoolException {
        try {
            this.close();
        }
        catch (SQLException sqle) {
            I18nLogManager.logError("RESOURCE_POOLING", "ERR.003.002.0048", (Throwable)sqle, new Object[]{CommonPlugin.Util.getString("ERR.003.002.0048", this.checkedOutBy)});
        }
    }

    public boolean isResourceAlive() throws ResourcePoolException {
        return this.checkIsResourceAlive();
    }

    public boolean validate() {
        try {
            this.conn.getMetaData();
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    protected boolean checkIsResourceAlive() {
        boolean result = true;
        if (this.platform.isClosed(this.conn)) {
            result = false;
        }
        try {
            this.conn.commit();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return false;
        }
        return result;
    }

    public void setHoldability(int holdability) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 0;
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }
}

