/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.jdbc;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.jdbc.JDBCUtil;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceAdapter;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.jdbc.JDBCApplicationConnectionResource;
import com.metamatrix.common.pooling.jdbc.JDBCConnectionResource;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCConnectionResourceAdapter
implements ResourceAdapter {
    private boolean decryptRequired = true;
    private boolean tracingEnabled;
    private static final Object lock = new Object();
    private static Long ID_CNTR = new Long(0L);
    private static final boolean DEFAULT_DECRYPTION_REQUIRED = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource createResource(Object physicalResource) throws ResourcePoolException {
        try {
            JDBCConnectionResource resource;
            Connection conn = this.convertToConnection(physicalResource);
            JDBCPlatform jdbcPlatform = JDBCPlatformFactory.getPlatform(conn);
            Object object = lock;
            synchronized (object) {
                Long nl = new Long(ID_CNTR + 1L);
                resource = !this.tracingEnabled ? new JDBCConnectionResource(conn, jdbcPlatform, nl) : new JDBCApplicationConnectionResource(conn, jdbcPlatform, nl);
                ID_CNTR = nl;
            }
            LogManager.logTrace("RESOURCE_POOLING", "Created resource for platform " + jdbcPlatform.getClass().getName());
            LogManager.logTrace("RESOURCE_POOLING", "Resource " + resource.getClass().getName());
            return resource;
        }
        catch (Exception e2) {
            throw new ResourcePoolException((Throwable)e2, "ERR.003.002.0045", CommonPlugin.Util.getString("ERR.003.002.0045"));
        }
    }

    public Object createPhysicalResourceObject(ResourceDescriptor descriptor) throws ResourcePoolException {
        Properties props = descriptor.getProperties();
        if (this.isDecryptRequired()) {
            try {
                props = CryptoUtil.propertyDecrypt("metamatrix.common.pooling.jdbc.Password", props);
            }
            catch (CryptoException e2) {
                throw new ResourcePoolException((Throwable)e2, "ERR.003.002.0044", CommonPlugin.Util.getString("ERR.003.002.0044", descriptor.getName()));
            }
        }
        String autocommit = props.getProperty("metamatrix.common.pooling.jdbc.autocommit", "false");
        String driverClassName = props.getProperty("metamatrix.common.pooling.jdbc.Driver");
        String protocol = props.getProperty("metamatrix.common.pooling.jdbc.Protocol");
        String database = props.getProperty("metamatrix.common.pooling.jdbc.Database");
        String username = props.getProperty("metamatrix.common.pooling.jdbc.User");
        String password = props.getProperty("metamatrix.common.pooling.jdbc.Password");
        String traceDebug = props.getProperty("sqlTracing", "false");
        this.tracingEnabled = Boolean.valueOf(traceDebug);
        System.setProperty("sqlTracing", String.valueOf(this.tracingEnabled));
        Properties jdbcEnv = new Properties();
        if (driverClassName != null) {
            jdbcEnv.setProperty("com.metamatrix.common.util.JDBCUtil.Driver", driverClassName);
        }
        if (protocol != null) {
            jdbcEnv.setProperty("com.metamatrix.common.util.JDBCUtil.Protocol", protocol);
        }
        if (database != null) {
            jdbcEnv.setProperty("com.metamatrix.common.util.JDBCUtil.Database", database);
        }
        if (username != null) {
            jdbcEnv.setProperty("com.metamatrix.common.util.JDBCUtil.User", username);
        }
        if (password != null) {
            jdbcEnv.setProperty("com.metamatrix.common.util.JDBCUtil.Password", password);
        }
        StringBuffer sb = null;
        if (database.startsWith("jdbc")) {
            sb = new StringBuffer(database);
        } else {
            sb = new StringBuffer("jdbc:");
            sb.append(protocol);
            sb.append(":");
            sb.append(database);
        }
        LogManager.logTrace("RESOURCE_POOLING", "Opening connection to JDBC " + sb.toString() + " user: " + username);
        try {
            Connection conn = JDBCUtil.createJDBCConnection(jdbcEnv);
            if (!autocommit.equalsIgnoreCase(Boolean.TRUE.toString())) {
                conn.setAutoCommit(false);
            }
            return conn;
        }
        catch (Exception e3) {
            throw new ResourcePoolException((Throwable)e3, "ERR.003.002.0046", CommonPlugin.Util.getString("ERR.003.002.0046", descriptor.getName()));
        }
    }

    public void closePhyicalResourceObject(Resource resource) throws ResourcePoolException {
        if (resource == null) {
            return;
        }
        if (resource instanceof JDBCConnectionResource) {
            JDBCConnectionResource conn = (JDBCConnectionResource)resource;
            if (conn.isResourceAlive()) {
                try {
                    Connection connection = conn.getConnection();
                    connection.close();
                }
                catch (SQLException e2) {
                    I18nLogManager.logError("RESOURCE_POOLING", "ERR.003.002.0048", (Throwable)e2, new Object[]{CommonPlugin.Util.getString("ERR.003.002.0048", resource.getCheckedOutBy())});
                }
            }
        } else {
            throw new ResourcePoolException("ERR.003.002.0047", CommonPlugin.Util.getString("ERR.003.002.0047", resource.getClass().getName()));
        }
    }

    private Connection convertToConnection(Object obj) throws ResourcePoolException {
        if (obj instanceof Connection) {
            return (Connection)obj;
        }
        throw new ResourcePoolException("ERR.003.002.0049", CommonPlugin.Util.getString("ERR.003.002.0049", obj.getClass().getName()));
    }

    public boolean isDecryptRequired() {
        return this.decryptRequired;
    }

    protected void setDecryptRequired(boolean decryptRequired) {
        this.decryptRequired = decryptRequired;
    }
}

