/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.syntax;

import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ExpressionOperator
implements Serializable {
    protected List selectors;
    protected String[] databaseStrings;
    protected String expression;
    protected boolean isPrefix = false;
    protected boolean isRepeating = false;
    protected Class nodeClass;
    protected static Hashtable allOperators;
    protected static Hashtable inverses;
    public static final String Count = "count";
    public static final String Sum = "sum";
    public static final String Average = "average";
    public static final String Maximum = "maximum";
    public static final String Minimum = "minimum";
    public static final String Ascending = "ascending";
    public static final String Descending = "descending";
    public static final String ToUpperCase = "toUpperCase";
    public static final String ToLowerCase = "toLowerCase";

    public ExpressionOperator() {
        this.selectors = new ArrayList();
    }

    public ExpressionOperator(List newSelectors, List newDatabaseStrings) {
        this.selectors = newSelectors;
        this.printsAs(newDatabaseStrings);
    }

    public static ExpressionOperator abs() {
        return ExpressionOperator.simpleFunction("abs", "ABS");
    }

    public static ExpressionOperator acos() {
        return ExpressionOperator.simpleFunction("acos", "ACOS");
    }

    public static ExpressionOperator addMonths() {
        return ExpressionOperator.simpleTwoArgumentFunction("addMonths", "ADD_MONTHS");
    }

    public static void addOperator(ExpressionOperator op) {
        Iterator it = op.getSelectors().iterator();
        while (it.hasNext()) {
            allOperators.put(it.next(), op);
        }
    }

    public void addSelector(String selector) {
        this.selectors.add(selector);
    }

    public static ExpressionOperator and() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("&");
        result.printsAs("AND");
        result.bePostfix();
        return result;
    }

    public Object applyTo(Object arg) {
        return arg;
    }

    public static ExpressionOperator ascending() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector(Ascending);
        result.setExpression(" {0} ASC");
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("ASC");
        result.printsAs(v2);
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator ascii() {
        return ExpressionOperator.simpleFunction("ascii", "ASCII");
    }

    public static ExpressionOperator asin() {
        return ExpressionOperator.simpleFunction("asin", "ASIN");
    }

    private static void associateInverses(String one, String theOther) {
        ExpressionOperator opOne = ExpressionOperator.getOperator(one);
        ExpressionOperator opTheOther = ExpressionOperator.getOperator(theOther);
        inverses.put(opOne, opTheOther);
        inverses.put(opTheOther, opOne);
    }

    public static ExpressionOperator atan() {
        return ExpressionOperator.simpleFunction("atan", "ATAN");
    }

    public static ExpressionOperator average() {
        return ExpressionOperator.simpleFunction(Average, "AVG");
    }

    public void bePostfix() {
        this.isPrefix = false;
    }

    public void bePrefix() {
        this.isPrefix = true;
    }

    public void beRepeating() {
        this.isRepeating = true;
    }

    public static ExpressionOperator between() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("between");
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("BETWEEN ");
        v2.add(" AND ");
        result.printsAs(v2);
        result.bePostfix();
        return result;
    }

    public static List binaryRelationOperators() {
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("=");
        v2.add("<");
        v2.add("<=");
        v2.add(">");
        v2.add(">=");
        v2.add("like");
        v2.add("notLike");
        v2.add("+");
        v2.add("-");
        v2.add("/");
        v2.add("*");
        return v2;
    }

    public static ExpressionOperator ceil() {
        return ExpressionOperator.simpleFunction("ceil", "CEIL");
    }

    public static ExpressionOperator chr() {
        return ExpressionOperator.simpleFunction("chr", "CHR");
    }

    public static ExpressionOperator concat() {
        return ExpressionOperator.simpleTwoArgumentFunction("concat", "CONCAT");
    }

    public static ExpressionOperator cos() {
        return ExpressionOperator.simpleFunction("cos", "COS");
    }

    public static ExpressionOperator cosh() {
        return ExpressionOperator.simpleFunction("cosh", "COSH");
    }

    public static ExpressionOperator count() {
        return ExpressionOperator.simpleFunction(Count, "COUNT");
    }

    public static ExpressionOperator dateToString() {
        return ExpressionOperator.simpleFunction("dateToString", "TO_CHAR");
    }

    public static ExpressionOperator deref() {
        return ExpressionOperator.simpleFunction("deref", "DEREF");
    }

    public static ExpressionOperator descending() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector(Descending);
        result.setExpression(" {0} DESC");
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("DESC");
        result.printsAs(v2);
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator equalOuterJoin() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("=*");
        return result;
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof ExpressionOperator)) {
            return false;
        }
        ExpressionOperator otherOperator = (ExpressionOperator)arg;
        if (this.getSelectors().size() == 0) {
            return false;
        }
        if (otherOperator.getSelectors().size() == 0) {
            return false;
        }
        return this.getSelectors().get(0).equals(otherOperator.getSelectors().get(0));
    }

    public static ExpressionOperator exp() {
        return ExpressionOperator.simpleFunction("exp", "EXP");
    }

    public static ExpressionOperator floor() {
        return ExpressionOperator.simpleFunction("floor", "FLOOR");
    }

    public static Hashtable getAllOperators() {
        if (allOperators == null) {
            ExpressionOperator.initializeOperators();
        }
        return allOperators;
    }

    public List getDatabaseStrings() {
        ArrayList<String> result = new ArrayList<String>(this.databaseStrings.length);
        for (int i2 = 0; i2 < this.databaseStrings.length; ++i2) {
            result.add(this.databaseStrings[i2]);
        }
        return result;
    }

    public static ExpressionOperator getInverse(ExpressionOperator operator) {
        return (ExpressionOperator)ExpressionOperator.getInverses().get(operator);
    }

    public static Hashtable getInverses() {
        if (inverses == null) {
            ExpressionOperator.initializeInverses();
        }
        return inverses;
    }

    public Class getNodeClass() {
        return this.nodeClass;
    }

    public static ExpressionOperator getOperator(String name) {
        return (ExpressionOperator)ExpressionOperator.getAllOperators().get(name);
    }

    public List getSelectors() {
        return this.selectors;
    }

    public static ExpressionOperator greatest() {
        return ExpressionOperator.simpleTwoArgumentFunction("greatest", "GREATEST");
    }

    public static ExpressionOperator hexToRaw() {
        return ExpressionOperator.simpleFunction("hexToRaw", "HEXTORAW");
    }

    public static ExpressionOperator in() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("in");
        result.printsAs("IN");
        return result;
    }

    public static ExpressionOperator initcap() {
        return ExpressionOperator.simpleFunction("initcap", "INITCAP");
    }

    protected static void initializeAggregateFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.count());
        ExpressionOperator.addOperator(ExpressionOperator.sum());
        ExpressionOperator.addOperator(ExpressionOperator.average());
        ExpressionOperator.addOperator(ExpressionOperator.minimum());
        ExpressionOperator.addOperator(ExpressionOperator.maximum());
        ExpressionOperator.addOperator(ExpressionOperator.variance());
        ExpressionOperator.addOperator(ExpressionOperator.standardDeviation());
    }

    protected static void initializeFunctionOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.notOperator());
    }

    private static void initializeInverses() {
        inverses = new Hashtable();
        ExpressionOperator.associateInverses("=", "!=");
        ExpressionOperator.associateInverses("<", ">=");
        ExpressionOperator.associateInverses("<=", ">");
        ExpressionOperator.associateInverses("like", "notLike");
        ExpressionOperator.associateInverses("isNull", "notNull");
    }

    protected static void initializeLogicalOperators() {
        ExpressionOperator.addOperator(ExpressionOperator.and());
        ExpressionOperator.addOperator(ExpressionOperator.or());
        ExpressionOperator.addOperator(ExpressionOperator.isNull());
        ExpressionOperator.addOperator(ExpressionOperator.notNull());
    }

    public static Hashtable initializeOperators() {
        ExpressionOperator.resetOperators();
        ExpressionOperator.initializeFunctionOperators();
        ExpressionOperator.initializeRelationOperators();
        ExpressionOperator.initializeLogicalOperators();
        ExpressionOperator.initializeAggregateFunctionOperators();
        return allOperators;
    }

    protected static void initializeRelationOperators() {
        Iterator it = ExpressionOperator.binaryRelationOperators().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ExpressionOperator.addOperator(ExpressionOperator.simpleRelation(name));
        }
        ExpressionOperator.addOperator(ExpressionOperator.in());
        ExpressionOperator.addOperator(ExpressionOperator.notIn());
        ExpressionOperator.addOperator(ExpressionOperator.like());
        ExpressionOperator.addOperator(ExpressionOperator.notLike());
        ExpressionOperator.addOperator(ExpressionOperator.notEqual());
        ExpressionOperator.addOperator(ExpressionOperator.equalOuterJoin());
        ExpressionOperator.addOperator(ExpressionOperator.between());
    }

    public static ExpressionOperator instring() {
        return ExpressionOperator.simpleTwoArgumentFunction("instring", "INSTRING");
    }

    public boolean isComplete() {
        return this.databaseStrings != null && this.databaseStrings.length != 0;
    }

    public static ExpressionOperator isNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("isNull");
        result.printsAs("IS NULL");
        result.bePostfix();
        return result;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public static ExpressionOperator lastDay() {
        return ExpressionOperator.simpleFunction("lastDay", "LAST_DAY");
    }

    public static ExpressionOperator least() {
        return ExpressionOperator.simpleTwoArgumentFunction("least", "LEAST");
    }

    public static ExpressionOperator leftPad() {
        return ExpressionOperator.simpleThreeArgumentFunction("leftPad", "LPAD");
    }

    public static ExpressionOperator leftTrim() {
        return ExpressionOperator.simpleTwoArgumentFunction("leftTrim", "LTRIM");
    }

    public static ExpressionOperator length() {
        return ExpressionOperator.simpleFunction("length", "LENGTH");
    }

    public static ExpressionOperator like() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("like");
        result.printsAs("LIKE");
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator ln() {
        return ExpressionOperator.simpleFunction("ln", "LN");
    }

    public static ExpressionOperator log() {
        return ExpressionOperator.simpleFunction("log", "LOG");
    }

    public static ExpressionOperator maximum() {
        return ExpressionOperator.simpleFunction(Maximum, "MAX");
    }

    public static ExpressionOperator minimum() {
        return ExpressionOperator.simpleFunction(Minimum, "MIN");
    }

    public static ExpressionOperator mod() {
        return ExpressionOperator.simpleTwoArgumentFunction("mod", "MOD");
    }

    public static ExpressionOperator monthsBetween() {
        return ExpressionOperator.simpleTwoArgumentFunction("monthsBetween", "MONTHS_BETWEEN");
    }

    public static ExpressionOperator nextDay() {
        return ExpressionOperator.simpleTwoArgumentFunction("nextDay", "NEXT_DAY");
    }

    public ExpressionOperator not() {
        return ExpressionOperator.getInverse(this);
    }

    public static ExpressionOperator notEqual() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("!=");
        result.printsAs("<>");
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator notIn() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("notIn");
        result.printsAs("NOT IN");
        return result;
    }

    public static ExpressionOperator notLike() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("notLike");
        result.printsAs("NOT LIKE");
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator notNull() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("notNull");
        result.printsAs("IS NOT NULL");
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator notOperator() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("not");
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add("NOT (");
        v2.add(")");
        result.printsAs(v2);
        result.bePrefix();
        return result;
    }

    public static ExpressionOperator or() {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector("|");
        result.printsAs("OR");
        result.bePostfix();
        return result;
    }

    public static ExpressionOperator power() {
        return ExpressionOperator.simpleTwoArgumentFunction("power", "POWER");
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String exp) {
        this.expression = exp;
    }

    public void printsAs(String s2) {
        ArrayList<String> v2 = new ArrayList<String>(1);
        v2.add(s2);
        this.printsAs(v2);
    }

    public void printsAs(List dbStrings) {
        this.databaseStrings = new String[dbStrings.size()];
        int i2 = 0;
        Iterator it = dbStrings.iterator();
        while (it.hasNext()) {
            this.databaseStrings[i2] = (String)it.next();
            ++i2;
        }
    }

    public static ExpressionOperator ref() {
        return ExpressionOperator.simpleFunction("ref", "REF");
    }

    public static ExpressionOperator refToHex() {
        return ExpressionOperator.simpleFunction("refToHex", "REFTOHEX");
    }

    public static ExpressionOperator refToValue() {
        return ExpressionOperator.simpleFunction("refToValue", "VALUE");
    }

    public static ExpressionOperator replace() {
        return ExpressionOperator.simpleThreeArgumentFunction("replace", "REPLACE");
    }

    public boolean representsEqualToNull(Object singleArgument) {
        if (singleArgument instanceof List) {
            return this.representsEqualToNull((List)singleArgument);
        }
        return this.selectors.get(0).equals("=") && singleArgument == null;
    }

    public boolean representsEqualToNull(List arguments) {
        return this.selectors.get(0).equals("=") && arguments.size() == 1 && arguments.get(0) == null;
    }

    public boolean representsNotEqualToNull(Object singleArgument) {
        if (singleArgument instanceof List) {
            return this.representsNotEqualToNull((List)singleArgument);
        }
        return this.selectors.get(0).equals("!=") && singleArgument == null;
    }

    public boolean representsNotEqualToNull(List arguments) {
        return this.selectors.get(0).equals("!=") && arguments.size() == 1 && arguments.get(0) == null;
    }

    public static void resetOperators() {
        allOperators = new Hashtable();
    }

    public static ExpressionOperator rightPad() {
        return ExpressionOperator.simpleThreeArgumentFunction("rightPad", "RPAD");
    }

    public static ExpressionOperator rightTrim() {
        return ExpressionOperator.simpleTwoArgumentFunction("rightTrim", "RTRIM");
    }

    public static ExpressionOperator round() {
        return ExpressionOperator.simpleTwoArgumentFunction("round", "ROUND");
    }

    public static ExpressionOperator roundDate() {
        return ExpressionOperator.simpleTwoArgumentFunction("roundDate", "ROUND");
    }

    public void setNodeClass(Class aClass) {
        this.nodeClass = aClass;
    }

    public static ExpressionOperator sign() {
        return ExpressionOperator.simpleFunction("sign", "SIGN");
    }

    public String buildExpression(String value) {
        String cmd = MessageFormat.format(this.getExpression(), value);
        return cmd;
    }

    public static ExpressionOperator simpleFunction(String name) {
        return ExpressionOperator.simpleFunction(name, name);
    }

    public static ExpressionOperator simpleFunction(String selector, String dbString) {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector(selector);
        result.setExpression(dbString + "( {0} )");
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add(dbString + "(");
        v2.add(")");
        result.printsAs(v2);
        result.bePrefix();
        return result;
    }

    public static ExpressionOperator simpleRelation(String name) {
        ExpressionOperator op = new ExpressionOperator();
        op.addSelector(name);
        op.printsAs(name);
        op.bePostfix();
        return op;
    }

    public static ExpressionOperator simpleThreeArgumentFunction(String selector, String dbString) {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector(selector);
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add(dbString + "(");
        v2.add(",");
        v2.add(",");
        v2.add(")");
        result.printsAs(v2);
        result.bePrefix();
        return result;
    }

    public static ExpressionOperator simpleTwoArgumentFunction(String selector, String dbString) {
        ExpressionOperator result = new ExpressionOperator();
        result.addSelector(selector);
        ArrayList<String> v2 = new ArrayList<String>();
        v2.add(dbString + "(");
        v2.add(",");
        v2.add(")");
        result.printsAs(v2);
        result.bePrefix();
        return result;
    }

    public static ExpressionOperator sin() {
        return ExpressionOperator.simpleFunction("sin", "SIN");
    }

    public static ExpressionOperator sinh() {
        return ExpressionOperator.simpleFunction("sinh", "SINH");
    }

    public static ExpressionOperator soundex() {
        return ExpressionOperator.simpleFunction("soundex", "SOUNDEX");
    }

    public static ExpressionOperator sqrt() {
        return ExpressionOperator.simpleFunction("sqrt", "SQRT");
    }

    public static ExpressionOperator standardDeviation() {
        return ExpressionOperator.simpleFunction("standardDeviation", "STDDEV");
    }

    public static ExpressionOperator substring() {
        return ExpressionOperator.simpleThreeArgumentFunction("substring", "SUBSTR");
    }

    public static ExpressionOperator sum() {
        return ExpressionOperator.simpleFunction(Sum, "Sum");
    }

    public static ExpressionOperator tan() {
        return ExpressionOperator.simpleFunction("tan", "TAN");
    }

    public static ExpressionOperator tanh() {
        return ExpressionOperator.simpleFunction("tanh", "TANH");
    }

    public static ExpressionOperator toDate() {
        return ExpressionOperator.simpleFunction("toDate", "TO_DATE");
    }

    public static ExpressionOperator today() {
        return ExpressionOperator.simpleFunction("today", "SYSDATE");
    }

    public static ExpressionOperator toLowerCase() {
        return ExpressionOperator.simpleFunction(ToLowerCase, "LOWER");
    }

    public static ExpressionOperator toNumber() {
        return ExpressionOperator.simpleFunction("toNumber", "TO_NUMBER");
    }

    public String toString() {
        if (this.selectors == null || this.selectors.size() == 0) {
            return "unknown operator";
        }
        return "operator " + this.selectors.get(0);
    }

    public static ExpressionOperator toUpperCase() {
        return ExpressionOperator.simpleFunction(ToUpperCase, "UCASE");
    }

    public static ExpressionOperator translate() {
        return ExpressionOperator.simpleThreeArgumentFunction("translate", "TRANSLATE");
    }

    public static ExpressionOperator trim() {
        return ExpressionOperator.simpleTwoArgumentFunction("trim", "TRIM");
    }

    public static ExpressionOperator trunc() {
        return ExpressionOperator.simpleTwoArgumentFunction("trunc", "TRUNC");
    }

    public static ExpressionOperator variance() {
        return ExpressionOperator.simpleFunction("variance", "VARIANCE");
    }

    protected void writeField(StringWriter writer, String fieldName) {
        if (this.isPrefix()) {
            writer.write(this.databaseStrings[0]);
            writer.write(fieldName);
        } else {
            writer.write(fieldName);
        }
        if (this.databaseStrings.length > 1) {
            writer.write(this.databaseStrings[1]);
        }
    }
}

