/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import java.util.HashMap;
import java.util.Map;

public class ProcedureType {
    public static final ProcedureType NO_RESULT = new ProcedureType(1, "No Result");
    public static final ProcedureType RESULT_UNKNOWN = new ProcedureType(0, "Result Unknown");
    public static final ProcedureType RETURNS_RESULT = new ProcedureType(2, "Returns Result");
    private int value;
    private String displayName;
    private static final Map BY_NAME = new HashMap();
    private static final Map BY_VALUE = new HashMap();

    private ProcedureType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    private static void add(ProcedureType instance) {
        BY_NAME.put(instance.getDisplayName(), instance);
        BY_VALUE.put(new Integer(instance.value), instance);
    }

    public static ProcedureType getInstance(String displayName) {
        return (ProcedureType)BY_NAME.get(displayName);
    }

    public static ProcedureType getInstance(int value) {
        return (ProcedureType)BY_VALUE.get(new Integer(value));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int compareTo(Object obj) {
        ProcedureType that = (ProcedureType)obj;
        if (obj == null) {
            throw new IllegalArgumentException("Attempt to compare null");
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcedureType) {
            ProcedureType that = (ProcedureType)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    static {
        ProcedureType.add(NO_RESULT);
        ProcedureType.add(RESULT_UNKNOWN);
        ProcedureType.add(RETURNS_RESULT);
    }
}

