/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.CommonPlugin;
import java.util.HashMap;
import java.util.Map;

public class ProcedureColumnType {
    public static final ProcedureColumnType COLUMN_UNKNOWN = new ProcedureColumnType(0, "Column Unknown");
    public static final ProcedureColumnType COLUMN_IN = new ProcedureColumnType(1, "Column In");
    public static final ProcedureColumnType COLUMN_INOUT = new ProcedureColumnType(2, "Column InOut");
    public static final ProcedureColumnType COLUMN_OUT = new ProcedureColumnType(4, "Column Out");
    public static final ProcedureColumnType COLUMN_RETURN = new ProcedureColumnType(5, "Column Return");
    public static final ProcedureColumnType COLUMN_RESULT = new ProcedureColumnType(3, "Column Result");
    private int value;
    private String displayName;
    private static final Map BY_NAME = new HashMap();
    private static final Map BY_VALUE = new HashMap();

    private ProcedureColumnType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public static ProcedureColumnType getInstance(String displayName) {
        return (ProcedureColumnType)BY_NAME.get(displayName);
    }

    public static ProcedureColumnType getInstance(int value) {
        return (ProcedureColumnType)BY_VALUE.get(new Integer(value));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static void add(ProcedureColumnType instance) {
        BY_NAME.put(instance.getDisplayName(), instance);
        BY_VALUE.put(new Integer(instance.value), instance);
    }

    public int compareTo(Object obj) {
        ProcedureColumnType that = (ProcedureColumnType)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.015.0022"));
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcedureColumnType) {
            ProcedureColumnType that = (ProcedureColumnType)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    static {
        ProcedureColumnType.add(COLUMN_UNKNOWN);
        ProcedureColumnType.add(COLUMN_IN);
        ProcedureColumnType.add(COLUMN_INOUT);
        ProcedureColumnType.add(COLUMN_OUT);
        ProcedureColumnType.add(COLUMN_RETURN);
        ProcedureColumnType.add(COLUMN_RESULT);
    }
}

