/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.core.util.ArgCheck;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class JDBCObject {
    public static final String DELIMITER = ".";
    private String name;
    private JDBCObject owner;
    private Properties properties;
    private Properties unmodProperties;
    private boolean marked;
    private boolean hasNullName;

    protected JDBCObject() {
        this.properties = new Properties();
        this.unmodProperties = new UnmodifiableProperties(this.properties);
    }

    protected JDBCObject(String name) {
        this.setName(name);
        this.properties = new Properties();
        this.unmodProperties = new UnmodifiableProperties(this.properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.name == null || this.name.length() != 0) {
            this.hasNullName = true;
        }
    }

    public boolean hasName() {
        return this.name != null && this.name.length() != 0;
    }

    public boolean getOriginalNameNull() {
        return this.hasNullName;
    }

    public void setOriginalNameNull(boolean nameWasNull) {
        this.hasNullName = nameWasNull;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean isMarked) {
        this.marked = isMarked;
        if (this.hasOwner()) {
            this.getOwner().setMarked(isMarked);
        }
    }

    public String getFullName() {
        return this.addFullName(new StringBuffer(), null).toString();
    }

    public String getFullName(String delimiter) {
        return this.addFullName(new StringBuffer(), delimiter).toString();
    }

    public JDBCObject getOwner() {
        return this.owner;
    }

    void setOwner(JDBCObject owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public String toString() {
        return this.getFullName();
    }

    protected StringBuffer addFullName(StringBuffer sb, String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = DELIMITER;
        }
        StringBuffer result = sb;
        if (this.owner != null && (result = this.owner.addFullName(result, delimiter)).length() != 0) {
            result.append(delimiter);
        }
        result.append(this.name);
        return result;
    }

    public Properties getProperties() {
        return this.unmodProperties;
    }

    public boolean hasProperties() {
        return this.properties != null && this.properties.size() != 0;
    }

    public String setProperty(String propName, String value) {
        return (String)this.properties.setProperty(propName, value);
    }

    public String removeProperty(String propName) {
        return (String)this.properties.remove(propName);
    }

    public String getProperty(String propName) {
        return this.properties.getProperty(propName);
    }

    public void print(PrintStream stream) {
        this.print(stream, "");
    }

    public void print(PrintStream stream, String lead) {
        if (stream == null) {
            ArgCheck.isNotNull(stream, "The stream reference may not be null");
        }
        stream.println(lead + this.getName() + (this.isMarked() ? " <marked>" : ""));
    }

    protected static JDBCObject lookupJDBCObject(List domain, String name, Class type) {
        if (name == null) {
            return null;
        }
        Iterator iter = domain.iterator();
        while (iter.hasNext()) {
            JDBCObject obj = (JDBCObject)iter.next();
            if (!type.isInstance(obj) || !name.equals(obj.getName())) continue;
            return obj;
        }
        return null;
    }
}

