/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.db;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.metadata.Column;
import com.metamatrix.common.jdbc.metadata.Table;
import com.metamatrix.common.jdbc.syntax.ExpressionOperator;
import com.metamatrix.common.jdbc.syntax.FieldType;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OraclePlatform
extends JDBCPlatform {
    private static final String EMPTY_BLOB = "empty_blob()";
    private static final String EMPTY_CLOB = "empty_clob()";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public OraclePlatform() {
        this.usesStreamsForBlobBinding = true;
        this.usesStreamsForClobBinding = true;
    }

    public boolean isOracle() {
        return true;
    }

    public int getMaxFieldNameSize() {
        return 37;
    }

    protected Map buildFieldTypes() {
        HashMap<Class, FieldType> fieldTypeMapping = new HashMap<Class, FieldType>();
        fieldTypeMapping.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = OraclePlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldType("NUMBER(1) default 0", false));
        fieldTypeMapping.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldType("NUMBER", 10));
        fieldTypeMapping.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldType("NUMBER", 19));
        fieldTypeMapping.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldType("NUMBER", false));
        fieldTypeMapping.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldType("NUMBER", false));
        fieldTypeMapping.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldType("NUMBER", 5));
        fieldTypeMapping.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldType("NUMBER", 3));
        fieldTypeMapping.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldType("NUMBER", 38));
        fieldTypeMapping.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldType("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(class$java$lang$String == null ? (class$java$lang$String = OraclePlatform.class$("java.lang.String")) : class$java$lang$String, new FieldType("VARCHAR2", 20));
        fieldTypeMapping.put(class$java$lang$Character == null ? (class$java$lang$Character = OraclePlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldType("CHAR", 1));
        fieldTypeMapping.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = OraclePlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldType("LONG RAW"));
        fieldTypeMapping.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = OraclePlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldType("LONG"));
        fieldTypeMapping.put(class$java$sql$Date == null ? (class$java$sql$Date = OraclePlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldType("DATE", false));
        fieldTypeMapping.put(class$java$sql$Time == null ? (class$java$sql$Time = OraclePlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldType("DATE", false));
        fieldTypeMapping.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = OraclePlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldType("DATE", false));
        return fieldTypeMapping;
    }

    protected Map buildPlatformOperators() {
        Map operators = super.buildPlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction("toUpperCase", "UPPER"));
        return operators;
    }

    public Map maximumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MAX_VALUE));
        values.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MAX_VALUE));
        values.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(9.9999E125));
        values.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        values.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        values.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MAX_VALUE));
        values.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("0"));
        values.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    public Map minimumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(class$java$lang$Integer == null ? (class$java$lang$Integer = OraclePlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(Integer.MIN_VALUE));
        values.put(class$java$lang$Long == null ? (class$java$lang$Long = OraclePlatform.class$("java.lang.Long")) : class$java$lang$Long, new Long(Long.MIN_VALUE));
        values.put(class$java$lang$Double == null ? (class$java$lang$Double = OraclePlatform.class$("java.lang.Double")) : class$java$lang$Double, new Double(-1.0E-129));
        values.put(class$java$lang$Short == null ? (class$java$lang$Short = OraclePlatform.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        values.put(class$java$lang$Byte == null ? (class$java$lang$Byte = OraclePlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        values.put(class$java$lang$Float == null ? (class$java$lang$Float = OraclePlatform.class$("java.lang.Float")) : class$java$lang$Float, new Float(Float.MIN_VALUE));
        values.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OraclePlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("0"));
        values.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = OraclePlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isClosed(Connection connection) {
        if (!super.isClosed(connection)) {
            boolean bl;
            Statement statement;
            block10: {
                statement = null;
                statement = connection.createStatement();
                statement.executeQuery("Select 'x' from DUAL");
                bl = false;
                Object var6_5 = null;
                if (statement == null) break block10;
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            return bl;
            catch (SQLException e3) {
                boolean bl2;
                block11: {
                    try {
                        bl2 = true;
                        Object var6_6 = null;
                        if (statement == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                                statement = null;
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                return bl2;
            }
        }
        return true;
    }

    public int setBlob(ResultSet results, byte[] data, String columnName) throws SQLException, IOException {
        int n2;
        OutputStream l_blobOutputStream;
        block7: {
            Blob blob = results.getBlob(columnName);
            l_blobOutputStream = null;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream is = new BufferedInputStream(bais);
            try {
                ReflectionHelper helper = new ReflectionHelper(blob.getClass());
                Object[] args = new Object[]{};
                Method m2 = helper.findBestMethodOnTarget("getBinaryOutputStream", args);
                l_blobOutputStream = (OutputStream)m2.invoke((Object)blob, args);
                byte[] l_buffer = new byte[10240];
                int cnt = ((InputStream)is).available();
                int l_nread = 0;
                while ((l_nread = ((InputStream)is).read(l_buffer)) != -1) {
                    l_blobOutputStream.write(l_buffer, 0, l_nread);
                }
                n2 = cnt;
                Object var16_16 = null;
                if (is == null) break block7;
            }
            catch (Exception nsme) {
                try {
                    throw new IOException(nsme.getMessage());
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var16_17 = null;
                        if (is != null) {
                            ((InputStream)is).close();
                            is = null;
                        }
                        if (l_blobOutputStream == null) break block8;
                        l_blobOutputStream.close();
                        l_blobOutputStream = null;
                    }
                    throw throwable;
                }
            }
            ((InputStream)is).close();
            is = null;
        }
        if (l_blobOutputStream != null) {
            l_blobOutputStream.close();
            l_blobOutputStream = null;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClob(ResultSet results, byte[] data, String columnName) throws SQLException, IOException {
        OutputStream l_clobOutputStream;
        block6: {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream is = new BufferedInputStream(bais);
            l_clobOutputStream = null;
            Clob clob = results.getClob(columnName);
            try {
                try {
                    ReflectionHelper helper = new ReflectionHelper(clob.getClass());
                    Object[] args = new Object[]{};
                    Method m2 = helper.findBestMethodOnTarget("getAsciiOutputStream", args);
                    l_clobOutputStream = (OutputStream)m2.invoke((Object)clob, args);
                    byte[] l_buffer = new byte[10240];
                    int l_nread = 0;
                    while ((l_nread = ((InputStream)is).read(l_buffer)) != -1) {
                        l_clobOutputStream.write(l_buffer, 0, l_nread);
                    }
                    Object var14_14 = null;
                    if (is == null) break block6;
                }
                catch (Exception nsme) {
                    nsme.printStackTrace();
                    throw new IOException(nsme.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (is != null) {
                    ((InputStream)is).close();
                    is = null;
                }
                if (l_clobOutputStream == null) throw throwable;
                l_clobOutputStream.close();
                l_clobOutputStream = null;
                throw throwable;
            }
            ((InputStream)is).close();
            is = null;
        }
        if (l_clobOutputStream == null) return;
        l_clobOutputStream.close();
    }

    public String createInsertStatement(Table tableMetadata) {
        ArrayList columns = new ArrayList(tableMetadata.getColumns());
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableMetadata.getFullName());
        sql.append(" (");
        String columnString = this.buildCommaSeperatedColumns(columns);
        int size = columns.size();
        sql.append(columnString);
        sql.append(")");
        sql.append(" VALUES ");
        sql.append("(");
        for (int k2 = 1; k2 <= size; ++k2) {
            if (((Column)columns.get(k2 - 1)).getDataType() == 2004 || ((Column)columns.get(k2 - 1)).getDataType() == 1111) {
                sql.append(EMPTY_BLOB);
            } else if (((Column)columns.get(k2 - 1)).getDataType() == 2005) {
                sql.append(EMPTY_CLOB);
            } else {
                sql.append("?");
            }
            if (k2 >= size) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    public boolean isDefault() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

