/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCURL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;

public class JDBCPlatformFactory {
    private static final String DEFAULT_PLATFORM = "default";
    private static final String COLON = ":";
    private static Map classMap;
    private static Map secureclassMap;
    private static Map platformCache;

    public static JDBCPlatform getPlatform(Connection jdbcConnection) throws MetaMatrixException {
        try {
            DatabaseMetaData metadata = jdbcConnection.getMetaData();
            String productName = metadata.getDatabaseProductName();
            String driverName = metadata.getDriverName();
            JDBCPlatform p2 = JDBCPlatformFactory.getPlatform(metadata.getURL(), driverName, productName);
            if (p2 != null) {
                p2.setConnection(jdbcConnection);
            }
            return p2;
        }
        catch (Exception sqle) {
            throw new MetaMatrixException((Throwable)sqle, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    public static JDBCPlatform getPlatform(String url, String driverName) throws MetaMatrixException {
        String productName = JDBCPlatformFactory.getSupportedByProtocol(url);
        return JDBCPlatformFactory.getPlatform(url, driverName, productName);
    }

    static JDBCPlatform getPlatform(String url, String driverName, String productName) throws MetaMatrixException {
        try {
            boolean isSecure = false;
            JDBCURL jdbcurl = new JDBCURL(url);
            String dbplatform = JDBCPlatformFactory.getSupportedByProductName(productName);
            String supported = JDBCPlatformFactory.getSupportedByProtocol(jdbcurl.getProtocol());
            if (supported == null) {
                supported = dbplatform;
            }
            if (supported == null) {
                supported = DEFAULT_PLATFORM;
            }
            String platformClass = null;
            if (supported.equalsIgnoreCase("sequelink")) {
                platformClass = JDBCPlatformFactory.getSecurePlatformClass(supported, dbplatform);
                if (platformClass == null) {
                    throw new MetaMatrixException("ERR.003.015.0004", CommonPlugin.Util.getString("ERR.003.015.0004", jdbcurl.getConnectionURL()));
                }
                isSecure = true;
            } else {
                platformClass = JDBCPlatformFactory.getPlatformClass(supported);
            }
            String key = driverName + " - " + jdbcurl.getProtocol();
            JDBCPlatform p2 = JDBCPlatformFactory.createPlatform(dbplatform, platformClass, key, isSecure);
            return p2;
        }
        catch (Exception sqle) {
            throw new MetaMatrixException((Throwable)sqle, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    private static JDBCPlatform createPlatform(String productName, String platformClass, String key, boolean isSecure) throws MetaMatrixException {
        try {
            JDBCPlatform p2 = JDBCPlatformFactory.getAvailablePlatform(platformClass, key);
            if (p2 != null) {
                return p2;
            }
            Object o2 = Class.forName(platformClass).newInstance();
            if (!(o2 instanceof JDBCPlatform)) {
                throw new MetaMatrixException("ERR.003.015.0005", CommonPlugin.Util.getString("ERR.003.015.0005"));
            }
            p2 = (JDBCPlatform)o2;
            if (isSecure) {
                p2.setIsSecure(isSecure);
            }
            p2.setPlatformName(productName);
            p2.initializePlatform();
            JDBCPlatformFactory.addAvailablePlatform(platformClass, key, p2);
            return p2;
        }
        catch (Exception cnfe) {
            throw new MetaMatrixException((Throwable)cnfe, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    private static JDBCPlatform getAvailablePlatform(String platform, String key) {
        JDBCPlatform p2 = null;
        HashMap platformInstances = null;
        if (platformCache.containsKey(platform)) {
            platformInstances = (HashMap)platformCache.get(platform);
            if (platformInstances.containsKey(key)) {
                p2 = (JDBCPlatform)platformInstances.get(key);
            }
        } else {
            platformInstances = new HashMap(10);
            platformCache.put(platform, platformInstances);
        }
        return p2;
    }

    private static void addAvailablePlatform(String platform, String key, JDBCPlatform jdbc) {
        Map platformInstances = (Map)platformCache.get(platform);
        platformInstances.put(key, jdbc);
    }

    static String getSupportedByProtocol(String value) {
        String lower = value.toLowerCase();
        if (lower.indexOf("metamatrix") >= 0) {
            return "metamatrix";
        }
        if (lower.indexOf("sequelink") >= 0) {
            return "sequelink";
        }
        if (lower.indexOf("mmx:oracle") >= 0) {
            return "mmx:oracle";
        }
        if (lower.indexOf("mssql") >= 0) {
            return "microsoft";
        }
        if (lower.indexOf("db2") >= 0) {
            return "db2";
        }
        if (lower.indexOf("oracle") >= 0) {
            return "oracle";
        }
        if (lower.indexOf("sybase") >= 0) {
            return "sybase";
        }
        if (lower.indexOf("informix-sqli") >= 0) {
            return "informix";
        }
        if (lower.indexOf("derby") >= 0) {
            return "derby";
        }
        return null;
    }

    static String getSupportedByProductName(String value) {
        String lower = value.toLowerCase();
        if (lower.indexOf("microsoft") >= 0) {
            return "microsoft";
        }
        if (lower.indexOf("db2") >= 0) {
            return "db2";
        }
        if (lower.indexOf("oracle") >= 0) {
            return "oracle";
        }
        if (lower.indexOf("sybase") >= 0) {
            return "sybase";
        }
        if (lower.indexOf("informix") >= 0) {
            return "informix";
        }
        if (lower.indexOf("metamatrix") >= 0) {
            return "metamatrix";
        }
        if (lower.indexOf("derby") >= 0) {
            return "derby";
        }
        return DEFAULT_PLATFORM;
    }

    static String getPlatformClass(String supported) {
        String platformClass = (String)classMap.get(supported);
        if (platformClass == null) {
            platformClass = (String)classMap.get(DEFAULT_PLATFORM);
        }
        return platformClass;
    }

    static String getSecurePlatformClass(String supported, String platform) {
        String key = supported + COLON + platform;
        return (String)secureclassMap.get(key);
    }

    static boolean isSecureConnection(String value) {
        String lower = value.toLowerCase();
        return lower.indexOf("sequelink") >= 0;
    }

    static {
        platformCache = new HashMap(10);
        classMap = new HashMap(10);
        classMap.put("db2", "com.metamatrix.common.jdbc.db.DB2Platform");
        classMap.put("microsoft", "com.metamatrix.common.jdbc.db.MSSQLPlatform");
        classMap.put("oracle", "com.metamatrix.common.jdbc.db.OraclePlatform");
        classMap.put("sybase", "com.metamatrix.common.jdbc.db.SybasePlatform");
        classMap.put("informix", "com.metamatrix.common.jdbc.db.InformixPlatform");
        classMap.put("metamatrix", "com.metamatrix.common.jdbc.db.MetaMatrixPlatform");
        classMap.put("mmx:oracle", "com.metamatrix.common.jdbc.db.MMOraclePlatform");
        classMap.put(DEFAULT_PLATFORM, "com.metamatrix.common.jdbc.JDBCPlatform");
        classMap.put("derby", "com.metamatrix.common.jdbc.db.DerbyPlatform");
        secureclassMap = new HashMap(4);
        secureclassMap.put("sequelink:oracle", "com.metamatrix.common.jdbc.db.MMOracleSecurePlatform");
        secureclassMap.put("sequelink:microsoft", "com.metamatrix.common.jdbc.db.MSSQLPlatform");
        secureclassMap.put("sequelink:db2", "com.metamatrix.common.jdbc.db.DB2Platform");
        secureclassMap.put("sequelink:sybase", "com.metamatrix.common.jdbc.db.SybasePlatform");
    }

    protected static interface PlatformClass {
        public static final String MSSQL = "com.metamatrix.common.jdbc.db.MSSQLPlatform";
        public static final String DB2 = "com.metamatrix.common.jdbc.db.DB2Platform";
        public static final String ORACLE = "com.metamatrix.common.jdbc.db.OraclePlatform";
        public static final String SYBASE = "com.metamatrix.common.jdbc.db.SybasePlatform";
        public static final String INFORMIX = "com.metamatrix.common.jdbc.db.InformixPlatform";
        public static final String METAMATRIX = "com.metamatrix.common.jdbc.db.MetaMatrixPlatform";
        public static final String DEFAULT = "com.metamatrix.common.jdbc.JDBCPlatform";
        public static final String MMORACLE = "com.metamatrix.common.jdbc.db.MMOraclePlatform";
        public static final String MMSECURE_ORACLE = "com.metamatrix.common.jdbc.db.MMOracleSecurePlatform";
        public static final String DERBY = "com.metamatrix.common.jdbc.db.DerbyPlatform";
    }

    protected static interface Protocol {
        public static final String MSSQL = "mssql";
        public static final String SQLSERVER = "sqlserver";
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SYBASE = "sybase";
        public static final String INFORMIX = "informix-sqli";
        public static final String METAMATRIX = "metamatrix";
        public static final String MM_ORACLE = "mmx:oracle";
        public static final String MM_SECURE = "sequelink";
        public static final String DERBY = "derby";
    }

    public static interface Supported {
        public static final String ORACLE = "oracle";
        public static final String SYBASE = "sybase";
        public static final String DB2 = "db2";
        public static final String MSSQL = "microsoft";
        public static final String INFORMIX = "informix";
        public static final String METAMATRIX = "metamatrix";
        public static final String MM_ORACLE = "mmx:oracle";
        public static final String MM_SECURE = "sequelink";
        public static final String DEFAULT = "default";
        public static final String DERBY = "derby";
    }
}

