/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid;

import com.metamatrix.common.CommonPlugin;
import java.io.Serializable;

public class ReservedIDBlock
implements Serializable {
    public static final long NO_ID_AVAILABLE = -1L;
    private String context;
    private long first;
    private long last;
    private long next;
    private long max;
    private boolean wrappable = false;

    public ReservedIDBlock(String context, long first, long last, long max) {
        if (first > last) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.013.0013", new Object[]{String.valueOf(first), String.valueOf(last)}));
        }
        this.context = context;
        this.first = first;
        this.next = first;
        if (last > max) {
            last = max;
        }
        this.last = last;
        this.max = max;
    }

    public long getNextID() {
        if (this.next > this.last) {
            return -1L;
        }
        ++this.next;
        return this.next - 1L;
    }

    public long getLast() {
        return this.last;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isDepleted() {
        return this.next > this.last;
    }

    public boolean isAtMaximum() {
        if (this.isDepleted()) {
            return this.last >= this.max;
        }
        return false;
    }

    public void setIsWrappable(boolean enableWrapping) {
        this.wrappable = enableWrapping;
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public long getMax() {
        return this.max;
    }

    public String toString() {
        return "ReservedIDBlock: first = " + this.first + " last = " + this.last + " next = " + this.next + " max = " + this.max + " wrappable = " + this.wrappable;
    }
}

