/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionDescriptor;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleUtil;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class JDBCExtensionModuleWriter {
    private static final String CONTEXT = "JDBC_EXT_MODULE_TRANSACTION";
    private static final int MAX_DESC_LEN = 4000;
    private static String IS_TRUE = "1";
    private static String IS_FALSE = "0";

    public static ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] data, long checksum, String description, boolean enabled, Connection jdbcConnection) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        String date = DateUtil.getCurrentDateAsString();
        return JDBCExtensionModuleWriter.addSource(principalName, date, principalName, date, type, sourceName, data, checksum, description, enabled, jdbcConnection);
    }

    /*
     * Unable to fully structure code
     */
    public static ExtensionModuleDescriptor addSource(String createdBy, String createdDate, String updatedBy, String updatedDate, String type, String sourceName, byte[] data, long checksum, String description, boolean enabled, Connection jdbcConnection) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        block17: {
            LogManager.logTrace("JDBC_EXT_MODULE_TRANSACTION", "adding extension module  " + sourceName + " containing # bytes: " + data.length);
            statement = null;
            sql = null;
            descriptor = null;
            description = StringUtil.truncString(description, 4000);
            position = JDBCExtensionModuleWriter.getNextPosition(jdbcConnection);
            isConfigModel = JDBCExtensionModuleUtil.isConfigurationModel(sourceName);
            try {
                sql = isConfigModel != false ? "INSERT  INTO CS_EXT_FILES(FILE_UID,CHKSUM,FILE_NAME,SEARCH_POS,IS_ENABLED,FILE_DESC,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATE_DATE,FILE_TYPE) VALUES " : "INSERT  INTO CS_EXT_FILES(FILE_UID,CHKSUM,FILE_NAME,SEARCH_POS,IS_ENABLED,FILE_DESC,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATE_DATE,FILE_TYPE) VALUES ";
                longUID = DBIDGenerator.getID("CS_EXT_FILES");
                sql = sql + "(?,?,?,?,?,?,?,?,?,?,?)";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setLong(1, longUID);
                statement.setLong(2, checksum);
                statement.setString(3, sourceName);
                statement.setInt(4, position);
                statement.setString(5, enabled != false ? JDBCExtensionModuleWriter.IS_TRUE : JDBCExtensionModuleWriter.IS_FALSE);
                statement.setString(6, description);
                statement.setString(7, createdBy);
                statement.setString(8, createdDate);
                statement.setString(9, updatedBy);
                statement.setString(10, updatedDate);
                statement.setString(11, type);
                if (statement.executeUpdate() != 1) {
                    if (JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0053", sourceName));
                        throw new DuplicateExtensionModuleException(sourceName);
                    }
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    throw new MetaMatrixComponentException("ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", sourceName, sql));
                }
                if (isConfigModel) {
                    JDBCExtensionModuleWriter.updateConfig(updatedBy, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= ?  WHERE FILE_NAME= ? ");
                } else {
                    JDBCExtensionModuleWriter.updateFile(updatedBy, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= empty_blob()  WHERE FILE_NAME= ? ");
                }
                descriptor = new JDBCExtensionDescriptor();
                descriptor.setName(sourceName);
                descriptor.setType(type);
                descriptor.setPosition(position);
                descriptor.setEnabled(enabled);
                descriptor.setDescription(description);
                descriptor.setCreatedBy(createdBy);
                descriptor.setCreationDate(createdDate);
                descriptor.setLastUpdatedBy(updatedBy);
                descriptor.setLastUpdatedDate(updatedDate);
                descriptor.setChecksum(checksum);
                var20_21 = null;
                ** if (statement == null) goto lbl-1000
            }
            catch (Throwable var19_25) {
                var20_22 = null;
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0048"));
                    }
                }
                throw var19_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException e) {
                    LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0048"));
                }
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (SQLException se) {
                    if (JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0053", sourceName));
                        throw new DuplicateExtensionModuleException(sourceName);
                    }
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", sourceName, sql));
                }
                catch (DuplicateExtensionModuleException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", sourceName, sql));
                }
            }
        }
        LogManager.logTrace("JDBC_EXT_MODULE_TRANSACTION", "success! " + sourceName);
        return descriptor;
    }

    public static void setSource(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        if (JDBCExtensionModuleUtil.isConfigurationModel(sourceName)) {
            JDBCExtensionModuleWriter.updateConfig(principalName, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= ?  WHERE FILE_NAME= ? ");
        } else {
            JDBCExtensionModuleWriter.updateFile(principalName, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= empty_blob()  WHERE FILE_NAME= ? ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void updateConfig(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection, String sql) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block28: {
            LogManager.logTrace("JDBC_EXT_MODULE_TRANSACTION", "setting extension module file " + sourceName + " containing # bytes: " + data.length);
            platform = JDBCExtensionModuleWriter.getPlatform(jdbcConnection);
            statement = null;
            oldAutoCommit = JDBCExtensionModuleWriter.getAutoCommit(jdbcConnection);
            if (platform.usesStreamsForClobBinding()) {
                jdbcConnection.setAutoCommit(false);
                sql = "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= empty_clob()  WHERE FILE_NAME= ? ";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                statement.setString(4, sourceName);
                if (statement.executeUpdate() != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
                statement.close();
                sql = "SELECT CONFIG_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
                sql = sql + " FOR UPDATE";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, sourceName);
                if (!statement.execute()) {
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0072", sql));
                    throw new MetaMatrixComponentException("ERR.014.004.0072", CommonPlugin.Util.getString("ERR.014.004.0072", sourceName, sql));
                }
                results = statement.getResultSet();
                try {
                    if (!results.next()) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0064", sourceName));
                        throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", sourceName));
                    }
                    platform.setClob(results, data, "CONFIG_CONTENTS");
                    var12_15 = null;
                    ** if (results == null) goto lbl-1000
                }
                catch (Throwable var11_19) {
                    var12_16 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException e) {
                            LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0073"));
                        }
                    }
                    throw var11_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0073"));
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
                if (oldAutoCommit != null && oldAutoCommit.booleanValue()) {
                    jdbcConnection.commit();
                }
            } else {
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                platform.setClob(statement, data, 4);
                statement.setString(5, sourceName);
                r = statement.executeUpdate();
                if (r != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
            }
            var15_20 = null;
            if (statement == null) break block28;
            try {
                statement.close();
                statement = null;
                break block28;
            }
            catch (SQLException e) {
                LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
            {
                break block28;
                catch (SQLException se) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
            }
            catch (Throwable var14_24) {
                var15_21 = null;
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning("JDBC_EXT_MODULE_TRANSACTION", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0048"));
                    }
                }
                JDBCExtensionModuleWriter.setAutoCommit(jdbcConnection, oldAutoCommit);
                throw var14_24;
            }
        }
        JDBCExtensionModuleWriter.setAutoCommit(jdbcConnection, oldAutoCommit);
    }

    /*
     * Loose catch block
     */
    private static void updateFile(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection, String sql) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Boolean oldAutoCommit;
        ResultSet results;
        block21: {
            LogManager.logTrace(CONTEXT, "setting extension module file " + sourceName + " containing # bytes: " + data.length);
            JDBCPlatform platform = JDBCExtensionModuleWriter.getPlatform(jdbcConnection);
            PreparedStatement statement = null;
            results = null;
            oldAutoCommit = JDBCExtensionModuleWriter.getAutoCommit(jdbcConnection);
            if (platform.usesStreamsForBlobBinding()) {
                jdbcConnection.setAutoCommit(false);
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                statement.setString(4, sourceName);
                if (statement.executeUpdate() != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0060", new Object[]{sourceName, sql}));
                    throw new MetaMatrixComponentException("ERR.014.004.0060", CommonPlugin.Util.getString("ERR.014.004.0060", sourceName, sql));
                }
                LogManager.logTrace(CONTEXT, "SUCCESS-reset Blob: " + sql);
                statement.close();
                sql = "SELECT FILE_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
                sql = sql + " FOR UPDATE";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, sourceName);
                if (!statement.execute()) {
                    LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0061", sql));
                    throw new MetaMatrixComponentException("ERR.014.004.0062", CommonPlugin.Util.getString("ERR.014.004.0062", sourceName, sql));
                }
                results = statement.getResultSet();
                if (!results.next()) {
                    LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0064", sourceName));
                    throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", sourceName));
                }
                platform.setBlob(results, data, "FILE_CONTENTS");
                if (oldAutoCommit != null && oldAutoCommit.booleanValue()) {
                    jdbcConnection.commit();
                }
            } else {
                sql = "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= ?  WHERE FILE_NAME= ? ";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                platform.setBlob(statement, data, 4);
                statement.setString(5, sourceName);
                if (statement.executeUpdate() != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
            }
            Object var13_10 = null;
            if (statement == null) break block21;
            try {
                statement.close();
                statement = null;
                break block21;
            }
            catch (SQLException e2) {
                LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
            {
                break block21;
                catch (SQLException se) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        LogManager.logError(CONTEXT, (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0059", sourceName));
                        throw new ExtensionModuleNotFoundException(sourceName);
                    }
                    LogManager.logError(CONTEXT, (Throwable)se, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
                catch (ExtensionModuleNotFoundException e3) {
                    throw e3;
                }
                catch (MetaMatrixComponentException e4) {
                    LogManager.logError(CONTEXT, (Throwable)e4, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw e4;
                }
                catch (Exception e5) {
                    LogManager.logError(CONTEXT, (Throwable)e5, CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                    throw new MetaMatrixComponentException((Throwable)e5, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", sql));
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e2) {
                        LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
                    }
                }
                JDBCExtensionModuleWriter.close(results);
                JDBCExtensionModuleWriter.setAutoCommit(jdbcConnection, oldAutoCommit);
                throw throwable;
            }
        }
        JDBCExtensionModuleWriter.close(results);
        JDBCExtensionModuleWriter.setAutoCommit(jdbcConnection, oldAutoCommit);
    }

    private static Boolean getAutoCommit(Connection jdbcConnection) {
        Boolean result = null;
        try {
            result = jdbcConnection.getAutoCommit();
        }
        catch (Exception e2) {
            LogManager.logError(CONTEXT, (Throwable)e2, e2.getMessage());
        }
        return result;
    }

    private static void setAutoCommit(Connection jdbcConnection, Boolean value) {
        try {
            if (value != null) {
                jdbcConnection.setAutoCommit(value);
            }
        }
        catch (Exception e2) {
            LogManager.logError(CONTEXT, (Throwable)e2, e2.getMessage());
        }
    }

    public static ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        try {
            String sql = "UPDATE CS_EXT_FILES  SET FILE_NAME= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
            JDBCExtensionModuleWriter.updateModule(sourceName, newName, sql, principalName, jdbcConnection);
            return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, jdbcConnection);
        }
        catch (SQLException e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        try {
            String sql = "UPDATE CS_EXT_FILES  SET FILE_DESC= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
            JDBCExtensionModuleWriter.updateModule(sourceName, description, sql, principalName, jdbcConnection);
            return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, jdbcConnection);
        }
        catch (SQLException e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static void setSearchOrder(String principalName, List sourceNames, Connection jdbcConnection) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        int rowCount = JDBCExtensionModuleReader.getExtensionModuleCount(jdbcConnection);
        if (sourceNames.size() != rowCount) {
            LogManager.logError(CONTEXT, CommonPlugin.Util.getString("ERR.014.004.0066", sourceNames));
            throw new ExtensionModuleOrderingException("ERR.014.004.0066", CommonPlugin.Util.getString("ERR.014.004.0066", sourceNames));
        }
        String aSourceName = null;
        Integer aPosition = null;
        String currentDate = DateUtil.getCurrentDateAsString();
        String sql = "UPDATE CS_EXT_FILES  SET SEARCH_POS= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
        try {
            PreparedStatement statement = jdbcConnection.prepareStatement(sql);
            ListIterator iter = sourceNames.listIterator();
            while (iter.hasNext()) {
                aPosition = new Integer(iter.nextIndex());
                aSourceName = (String)iter.next();
                statement.setInt(1, aPosition);
                statement.setString(2, principalName);
                statement.setString(3, currentDate);
                statement.setString(4, aSourceName);
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (SQLException e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    public static void setEnabled(String principalName, Collection sourceNames, boolean enabled, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        String aSourceName = null;
        String currentDate = DateUtil.getCurrentDateAsString();
        String sql = "UPDATE CS_EXT_FILES  SET SEARCH_POS= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
        try {
            PreparedStatement statement = jdbcConnection.prepareStatement(sql);
            Iterator iter = sourceNames.iterator();
            while (iter.hasNext()) {
                aSourceName = (String)iter.next();
                statement.setString(1, enabled ? IS_TRUE : IS_FALSE);
                statement.setString(2, principalName);
                statement.setString(3, currentDate);
                statement.setString(4, aSourceName);
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (SQLException e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateModule(String filenname, String value, String sql, String callerPrincipalName, Connection jdbcConnection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, value);
            statement.setString(2, callerPrincipalName);
            statement.setString(3, DateUtil.getCurrentDateAsString());
            statement.setString(4, filenname);
            statement.execute();
            Object var7_6 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e2) {
                LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e2) {
            LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
        }
    }

    private static JDBCPlatform getPlatform(Connection jdbcConnection) throws MetaMatrixComponentException {
        try {
            return JDBCPlatformFactory.getPlatform(jdbcConnection);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0067", CommonPlugin.Util.getString("ERR.014.004.0067"));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeSource(String principalName, String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        PreparedStatement statement = null;
        statement = jdbcConnection.prepareStatement("DELETE  FROM CS_EXT_FILES WHERE FILE_NAME=?");
        statement.setString(1, sourceName);
        statement.execute();
        Object var6_4 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e2) {
            LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
        }
        return;
        {
            catch (SQLException e3) {
                throw new MetaMatrixComponentException(e3);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e2) {
                LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
            throw throwable;
        }
    }

    static int getNextPosition(Connection jdbcConnection) throws MetaMatrixComponentException {
        int nextPos = JDBCExtensionModuleReader.executeIntFunctionSQL("SELECT  MAX(SEARCH_POS) FROM CS_EXT_FILES", jdbcConnection);
        return ++nextPos;
    }

    private static void close(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
                resultset = null;
            }
            catch (SQLException e2) {
                LogManager.logWarning(CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
        }
    }
}

