/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.CRC32;

public final class JDBCExtensionModuleUtil {
    private static final String LOG_CONTEXT = "EXTENSION_MODULE";
    private static final String PRINCIPAL = "JDBCExtensionUtil";
    private static Set configurationNames = new HashSet();
    private Properties properties;

    public JDBCExtensionModuleUtil(Properties overrideResourceProps) {
        this.properties = overrideResourceProps;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Properties resourceProps = null;
        try {
            resourceProps = CurrentConfiguration.getResourceProperties("ExtensionSourceManager");
        }
        catch (Exception e2) {
            LogManager.logError(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0001"));
        }
        if (resourceProps != null) {
            boolean deepClone = true;
            boolean makeUnmodifiable = false;
            this.properties = PropertiesUtils.clone(this.properties, resourceProps, deepClone, makeUnmodifiable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportExtensionModule(OutputStream outputStream, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Connection connection = null;
        try {
            try {
                int bytesRead;
                connection = JDBCConnectionPoolHelper.getConnection(this.properties, PRINCIPAL);
                byte[] data = JDBCExtensionModuleReader.getSource(sourceName, connection);
                if (data == null) {
                    System.out.println(CommonPlugin.Util.getString("ERR.014.004.0068", sourceName));
                    throw new ExtensionModuleNotFoundException("ERR.014.004.0069", CommonPlugin.Util.getString("ERR.014.004.0069", sourceName));
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                BufferedInputStream isContent = new BufferedInputStream(bais);
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = ((InputStream)isContent).read(buff, 0, buff.length))) {
                    outputStream.write(buff, 0, bytesRead);
                }
                outputStream.flush();
                outputStream.close();
            }
            catch (ExtensionModuleNotFoundException notFound) {
                throw notFound;
            }
            catch (Exception e2) {
                throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0070", CommonPlugin.Util.getString("ERR.014.004.0070", sourceName));
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e1) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportExtensionModule(String outputFileName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Connection connection = null;
        try {
            try {
                connection = JDBCConnectionPoolHelper.getConnection(this.properties, PRINCIPAL);
                byte[] data = JDBCExtensionModuleReader.getSource(sourceName, connection);
                if (data == null) throw new ExtensionModuleNotFoundException("ERR.014.004.0069", CommonPlugin.Util.getString("ERR.014.004.0069", sourceName));
                if (data.length == 0) {
                    throw new ExtensionModuleNotFoundException("ERR.014.004.0069", CommonPlugin.Util.getString("ERR.014.004.0069", sourceName));
                }
                FileUtils.write(data, outputFileName);
            }
            catch (ExtensionModuleNotFoundException notFound) {
                throw notFound;
            }
            catch (Exception e2) {
                throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", sourceName, outputFileName));
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e1) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importExtensionModule(String importFileName, String extName, String extType, String extDesc) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        Connection connection = null;
        FileInputStream stream = null;
        try {
            try {
                byte[] data;
                connection = JDBCConnectionPoolHelper.getConnection(this.properties, PRINCIPAL);
                boolean inuse = JDBCExtensionModuleReader.isNameInUse(extName, connection);
                File aFile = new File(importFileName);
                if (!aFile.exists()) {
                    throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", importFileName));
                }
                try {
                    stream = new FileInputStream(aFile);
                }
                catch (FileNotFoundException e2) {
                    throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", importFileName));
                }
                int size = (int)aFile.length();
                try {
                    data = ByteArrayHelper.toByteArray(stream, size + 1);
                }
                catch (IOException e1) {
                    throw new MetaMatrixComponentException((Throwable)e1, "ERR.014.004.0070", CommonPlugin.Util.getString("ERR.014.004.0070", importFileName));
                }
                if (inuse) {
                    JDBCExtensionModuleWriter.setSource(PRINCIPAL, extName, data, this.getChecksum(data), connection);
                } else {
                    JDBCExtensionModuleWriter.addSource(PRINCIPAL, extType, extName, data, this.getChecksum(data), extDesc, true, connection);
                }
                connection.commit();
            }
            catch (MetaMatrixComponentException mce) {
                throw mce;
            }
            catch (Exception e3) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (stream == null) throw new MetaMatrixComponentException(e3);
                try {
                    stream.close();
                    throw new MetaMatrixComponentException(e3);
                }
                catch (IOException e33) {
                    // empty catch block
                }
                throw new MetaMatrixComponentException(e3);
            }
            Object var13_17 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e1) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    public static boolean isConfigurationModel(String sourceName) {
        return configurationNames.contains(sourceName);
    }

    static void addConfigurationModelName(String sourceName) {
        configurationNames.add(sourceName);
    }

    static void removeConfigurationModelName(String sourceName) {
        configurationNames.remove(sourceName);
    }

    public void importExtensionModule(String importFileName, String extName, String extType, String extDesc, String position) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        this.importExtensionModule(importFileName, extName, extType, extDesc);
        this.positionExtensionModule(extName, position);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteExtensionModule(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block11: {
            block10: {
                connection = null;
                try {
                    try {
                        connection = JDBCConnectionPoolHelper.getConnection(this.properties, "JDBCExtensionUtil");
                        inuse = JDBCExtensionModuleReader.isNameInUse(sourceName, connection);
                        if (!inuse) {
                            var5_5 = null;
                            break block10;
                        }
                        JDBCExtensionModuleWriter.removeSource("JDBCExtensionUtil", sourceName, connection);
                        break block11;
                    }
                    catch (Exception e) {
                        throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0071", CommonPlugin.Util.getString("ERR.014.004.0071", sourceName));
                    }
                }
                catch (Throwable var4_11) {
                    var5_7 = null;
                    try {
                        if (connection == null) throw var4_11;
                        connection.close();
                        throw var4_11;
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    throw var4_11;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 72->85)] { 
lbl26:
            // 1 sources

            if (connection == null) return;
            connection.close();
            return;
lbl29:
            // 1 sources

            catch (SQLException e1) {
                // empty catch block
            }
            return;
        }
        var5_6 = null;
        try {}
        catch (SQLException e1) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void positionExtensionModule(String extName, String position) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        int pos = -1;
        if (position == null) {
            return;
        }
        try {
            pos = new Integer(position);
        }
        catch (Throwable t2) {
            return;
        }
        Connection connection = null;
        try {
            try {
                connection = JDBCConnectionPoolHelper.getConnection(this.properties, PRINCIPAL);
                LinkedList<String> orderList = new LinkedList<String>();
                List descriptors = JDBCExtensionModuleReader.getSourceDescriptors(null, true, connection);
                ExtensionModuleDescriptor desc = null;
                boolean inserted = false;
                Iterator it = descriptors.iterator();
                while (it.hasNext()) {
                    desc = (ExtensionModuleDescriptor)it.next();
                    if (desc.getName().equals(extName)) continue;
                    if (!inserted) {
                        if (desc.getPosition() < pos) {
                            orderList.add(desc.getName());
                            continue;
                        }
                        if (desc.getPosition() < pos) continue;
                        orderList.add(extName);
                        orderList.add(desc.getName());
                        inserted = true;
                        continue;
                    }
                    orderList.add(desc.getName());
                }
                JDBCExtensionModuleWriter.setSearchOrder(PRINCIPAL, orderList, connection);
                connection.commit();
            }
            catch (MetaMatrixComponentException mce) {
                throw mce;
            }
            catch (Exception e2) {
                try {
                    connection.rollback();
                    throw new MetaMatrixComponentException(e2);
                }
                catch (SQLException e3) {
                    // empty catch block
                }
                throw new MetaMatrixComponentException(e2);
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e1) {}
        if (connection == null) return;
        connection.close();
        return;
    }

    private long getChecksum(byte[] data) {
        CRC32 algorithm = new CRC32();
        algorithm.update(data, 0, data.length);
        return algorithm.getValue();
    }

    static {
        configurationNames.add("Next Startup");
        configurationNames.add("Startup");
    }
}

