/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.file;

import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import java.io.Serializable;
import java.util.StringTokenizer;

public class FileEMDescriptor
implements ExtensionModuleDescriptor,
Serializable {
    private static final String ENABLED_TOKEN = "enabled";
    private static final String DISABLED_TOKEN = "disabled";
    private static final String DELIM_CHAR = ",";
    String name;
    String type;
    int position;
    boolean enabled;
    String desc;
    String createdBy;
    String creationDate;
    String lastUpdatedBy;
    String lastUpdatedDate;
    long checksum;
    long timestamp;

    FileEMDescriptor() {
    }

    FileEMDescriptor(String name, int position, String principal, String timestamps, long checksum, long timestamp) {
        this.name = name;
        this.position = position;
        this.createdBy = principal;
        this.lastUpdatedBy = principal;
        this.creationDate = timestamps;
        this.lastUpdatedDate = timestamps;
        this.checksum = checksum;
        this.timestamp = timestamp;
        this.type = "JAR File";
        this.enabled = true;
    }

    FileEMDescriptor(int searchPosition, String tokenizedString) throws NumberFormatException {
        this.position = searchPosition;
        StringTokenizer toke = new StringTokenizer(tokenizedString, DELIM_CHAR);
        this.name = toke.nextToken();
        this.type = toke.nextToken();
        this.enabled = toke.nextToken().equalsIgnoreCase(ENABLED_TOKEN);
        this.createdBy = toke.nextToken();
        this.creationDate = toke.nextToken();
        this.lastUpdatedBy = toke.nextToken();
        this.lastUpdatedDate = toke.nextToken();
        this.checksum = Long.parseLong(toke.nextToken());
        this.timestamp = Long.parseLong(toke.nextToken());
        if (toke.hasMoreTokens()) {
            this.desc = toke.nextToken();
        }
    }

    String writableString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(this.name);
        s2.append(DELIM_CHAR);
        s2.append(this.type);
        s2.append(DELIM_CHAR);
        if (this.enabled) {
            s2.append(ENABLED_TOKEN);
        } else {
            s2.append(DISABLED_TOKEN);
        }
        s2.append(DELIM_CHAR);
        s2.append(this.createdBy);
        s2.append(DELIM_CHAR);
        s2.append(this.creationDate);
        s2.append(DELIM_CHAR);
        s2.append(this.lastUpdatedBy);
        s2.append(DELIM_CHAR);
        s2.append(this.lastUpdatedDate);
        s2.append(DELIM_CHAR);
        s2.append(String.valueOf(this.checksum));
        s2.append(DELIM_CHAR);
        s2.append(String.valueOf(this.timestamp));
        if (this.desc != null) {
            s2.append(DELIM_CHAR);
            s2.append(this.desc);
        }
        return s2.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public int compareTo(Object obj) {
        ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
        if (obj == null) {
            throw new RuntimeException("Attempt to compare null");
        }
        if (obj == this) {
            return 0;
        }
        return this.position - that.getPosition();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtensionModuleDescriptor) {
            ExtensionModuleDescriptor that = (ExtensionModuleDescriptor)obj;
            return this.position == that.getPosition();
        }
        return false;
    }

    public String toString() {
        return "Extension Source: " + this.name;
    }
}

