/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.ConfigurationPropertyNames;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.Assertion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class XMLConfig_Base_ImportExportUtility
implements ConfigurationPropertyNames {
    private XMLReaderWriter readerWriter;
    public static final String DEFAULT_USER_CREATED_BY = "Unknown";
    static final int CONFIGURATIONS_INDEX = 0;
    static final int PRODUCT_TYPES_INDEX = 1;
    static final int HOSTS_INDEX = 2;
    static final int DEPLOYED_COMPONENTS_INDEX = 3;
    static final int SERVICE_COMPONENT_DEFNS_INDEX = 4;
    static final int VM_COMPONENT_DEFNS_INDEX = 5;
    static final int COMPONENT_TYPES_INDEX = 6;
    static final int PRODUCT_SERVICE_CONFIGS_INDEX = 7;
    static final int CONNECTION_POOL_CONFIGS_INDEX = 16;
    static final int RESOURCES_INDEX = 18;
    static final int CONNECTORS_INDEX = 19;
    static final int CONFIGURATION_IDS_INDEX = 8;
    static final int PRODUCT_TYPE_IDS_INDEX = 9;
    static final int HOST_IDS_INDEX = 10;
    static final int DEPLOYED_COMPONENT_IDS_INDEX = 11;
    static final int SERVICE_COMPONENT_DEFN_IDS_INDEX = 12;
    static final int VM_COMPONENT_DEFN_IDS_INDEX = 13;
    static final int COMPONENT_TYPE_IDS_INDEX = 14;
    static final int PRODUCT_SERVICE_CONFIG_IDS_INDEX = 15;
    static final int CONNECTORS_IDS_INDEX = 20;
    static final int NUMBER_OF_LISTS = 21;

    public void exportComponentType(OutputStream stream, ComponentType type, Properties props) throws IOException {
        Assertion.isNotNull(type);
        Assertion.isNotNull(stream);
        XMLHelper helper = this.getXMLHelper();
        Element root = helper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Element componentTypesElement = helper.createComponentTypesElement();
        root.addContent(componentTypesElement);
        componentTypesElement.addContent(helper.createComponentTypeElement(type));
        this.getXMLReaderWriter().writeDocument(doc, stream);
    }

    public void exportComponentTypes(OutputStream stream, ComponentType[] types, Properties props) throws IOException {
        Assertion.isNotNull(types);
        Assertion.isNotNull(stream);
        XMLHelper helper = this.getXMLHelper();
        Element root = helper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Element componentTypesElement = helper.createComponentTypesElement();
        root.addContent(componentTypesElement);
        int s2 = types.length;
        for (int i2 = 0; i2 < s2; ++i2) {
            ComponentType type = types[i2];
            componentTypesElement.addContent(helper.createComponentTypeElement(type));
        }
        this.getXMLReaderWriter().writeDocument(doc, stream);
    }

    public void exportServiceComponentDefn(OutputStream stream, ServiceComponentDefn defn, ComponentType type, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        Assertion.isNotNull(defn);
        Assertion.isNotNull(type);
        Assertion.isNotNull(stream);
        ArrayList<BaseObject> configurationObjects = new ArrayList<BaseObject>(2);
        configurationObjects.add(defn);
        configurationObjects.add(type);
        this.resolveConfigurationObjects(configurationObjects);
        XMLHelper helper = this.getXMLHelper();
        Element root = helper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Element componentTypesElement = helper.createComponentTypesElement();
        root.addContent(componentTypesElement);
        componentTypesElement.addContent(helper.createComponentTypeElement(type));
        Element serviceComponentDefnsElement = helper.createServiceComponentDefnsElement();
        root.addContent(serviceComponentDefnsElement);
        serviceComponentDefnsElement.addContent(helper.createServiceComponentDefnElement(defn));
        this.getXMLReaderWriter().writeDocument(doc, stream);
    }

    protected Collection createConnectorBindings(ConfigurationID configurationID, Element root, ConfigurationObjectEditor editor, boolean importExistingBinding) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Element connectorsElement = root.getChild("ConnectorBindings");
        if (connectorsElement == null) {
            return Collections.EMPTY_LIST;
        }
        List connectorBindings = connectorsElement.getChildren("Connector");
        ArrayList<ConnectorBinding> connObjects = new ArrayList<ConnectorBinding>(connectorBindings.size());
        if (connectorBindings != null) {
            Iterator iterator = connectorBindings.iterator();
            while (iterator.hasNext()) {
                Element connElement = (Element)iterator.next();
                ConnectorBinding conn = this.getXMLHelper().createConnectorBinding(configurationID, connElement, editor, null, importExistingBinding);
                connObjects.add(conn);
            }
        }
        return connObjects;
    }

    protected ConnectorBinding createConnectorBinding(ConfigurationID configurationID, Element root, ConfigurationObjectEditor editor, String name, boolean isImportConfig) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Iterator iterator;
        Element connectorsElement = root.getChild("ConnectorBindings");
        if (connectorsElement == null) {
            return null;
        }
        List connectorBindings = connectorsElement.getChildren("Connector");
        if (connectorBindings != null && (iterator = connectorBindings.iterator()).hasNext()) {
            Element connElement = (Element)iterator.next();
            ConnectorBinding conn = this.getXMLHelper().createConnectorBinding(configurationID, connElement, editor, name, isImportConfig);
            return conn;
        }
        return null;
    }

    public Object[] importServiceComponentDefn(InputStream stream, Configuration config, ConfigurationObjectEditor editor, String[] name) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Assertion.isNotNull(stream);
        Assertion.isNotNull(editor);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e2) {
            e2.printStackTrace();
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0006"));
        }
        XMLHelper helper = this.getXMLHelper();
        Element root = doc.getRootElement();
        ComponentType type = this.createComponentType(root, editor, name[0]);
        Element serviceComponentDefnsElement = root.getChild("Configuration.ServiceComponentDefns");
        if (serviceComponentDefnsElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", "Configuration.ServiceComponentDefns"));
        }
        Element serviceComponentDefnElement = serviceComponentDefnsElement.getChild("ServiceComponentDefn");
        ComponentDefn cd = helper.createServiceComponentDefn(serviceComponentDefnElement, config, editor, name[1]);
        Object[] object = new Object[]{type, cd};
        return object;
    }

    protected ComponentType createComponentType(Element root, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        XMLHelper helper = this.getXMLHelper();
        Element componentTypesElement = root.getChild("ComponentTypes");
        if (componentTypesElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", "ComponentTypes"));
        }
        Element componentTypeElement = componentTypesElement.getChild("ComponentType");
        if (componentTypeElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", "ComponentType"));
        }
        return helper.createComponentType(componentTypeElement, editor, name, true);
    }

    public void exportConnector(OutputStream stream, ComponentType type, Properties props) throws IOException {
        this.exportComponentType(stream, type, props);
    }

    public void exportConnectorBinding(OutputStream stream, ConnectorBinding defn, ComponentType type, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        Assertion.isNotNull(defn);
        Assertion.isNotNull(type);
        Assertion.isNotNull(stream);
        this.resolveConnector(type, defn);
        XMLHelper helper = this.getXMLHelper();
        Element root = helper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Element componentTypesElement = helper.createComponentTypesElement();
        root.addContent(componentTypesElement);
        componentTypesElement.addContent(helper.createComponentTypeElement(type));
        Element connectorsElement = helper.createConnectorBindingsElement();
        root.addContent(connectorsElement);
        Element connElement = helper.createConnectorBindingElement(defn, false);
        connectorsElement.addContent(connElement);
        this.getXMLReaderWriter().writeDocument(doc, stream);
    }

    public void exportConnectorBindings(OutputStream stream, ConnectorBinding[] bindings, ComponentType[] types, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        Assertion.isNotNull(bindings);
        Assertion.isNotNull(types);
        Assertion.isNotNull(stream);
        XMLHelper helper = this.getXMLHelper();
        Element root = helper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        this.exportConnectorBindings(bindings, types, root);
        this.getXMLReaderWriter().writeDocument(doc, stream);
    }

    public void exportConnectorBindings(ConnectorBinding[] bindings, ComponentType[] types, Element root) {
        int i2;
        XMLHelper helper = this.getXMLHelper();
        int s2 = bindings.length;
        ArrayList<String> ts = new ArrayList<String>(s2);
        Element componentTypesElement = helper.createComponentTypesElement();
        root.addContent(componentTypesElement);
        Element connectorsElement = helper.createConnectorBindingsElement();
        root.addContent(connectorsElement);
        if (bindings == null || bindings.length == 0) {
            return;
        }
        int tsize = types.length;
        HashMap<BaseID, ComponentType> typeMap = new HashMap<BaseID, ComponentType>(tsize);
        for (i2 = 0; i2 < tsize; ++i2) {
            ComponentType type = types[i2];
            if (type == null) continue;
            typeMap.put(type.getID(), type);
        }
        for (i2 = 0; i2 < s2; ++i2) {
            ConnectorBinding cb = bindings[i2];
            if (cb == null) continue;
            ComponentType type = (ComponentType)typeMap.get(cb.getComponentTypeID());
            if (type != null && !ts.contains(type.getFullName())) {
                componentTypesElement.addContent(helper.createComponentTypeElement(type));
                ts.add(type.getFullName());
            }
            Element connElement = helper.createConnectorBindingElement(cb, false);
            connectorsElement.addContent(connElement);
        }
    }

    public ConnectorBinding importConnectorBinding(InputStream stream, ConfigurationObjectEditor editor, String newName) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Assertion.isNotNull(stream);
        Assertion.isNotNull(editor);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e2) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0010"));
        }
        Element root = doc.getRootElement();
        ConnectorBinding binding = this.createConnectorBinding(Configuration.NEXT_STARTUP_ID, root, editor, newName, false);
        if (binding == null) {
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0011", (Object)CommonPlugin.Util.getString("ERR.003.001.0011"));
        }
        return binding;
    }

    public Collection importConnectorBindings(Element root, ConfigurationObjectEditor editor, boolean importExistingBinding) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Assertion.isNotNull(root);
        Assertion.isNotNull(editor);
        Collection connectorBindings = this.createConnectorBindings(Configuration.NEXT_STARTUP_ID, root, editor, importExistingBinding);
        return connectorBindings;
    }

    public Collection importConnectorBindings(InputStream stream, ConfigurationObjectEditor editor, boolean importExistingBinding) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Assertion.isNotNull(stream);
        Assertion.isNotNull(editor);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e2) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0010"));
        }
        Element root = doc.getRootElement();
        return this.importConnectorBindings(root, editor, importExistingBinding);
    }

    public Object[] importConnectorBindingAndType(InputStream stream, ConfigurationObjectEditor editor, String[] newName) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Element root;
        ComponentType type;
        Assertion.isNotNull(stream);
        Assertion.isNotNull(editor);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(stream);
        }
        catch (JDOMException e2) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.001.0012"));
        }
        String typeName = null;
        String bindingName = null;
        if (newName != null) {
            typeName = newName[0];
            bindingName = newName[1];
        }
        if ((type = this.createComponentType(root = doc.getRootElement(), editor, typeName)) == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0013", (Object)CommonPlugin.Util.getString("ERR.003.001.0013"));
        }
        ConnectorBinding binding = this.createConnectorBinding(Configuration.NEXT_STARTUP_ID, root, editor, bindingName, false);
        if (binding == null) {
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0014", (Object)CommonPlugin.Util.getString("ERR.003.001.0014"));
        }
        this.resolveConnector(type, binding);
        Object[] object = new Object[]{type, binding};
        return object;
    }

    private void resolveConnector(ComponentType type, ComponentDefn defn) throws ConfigObjectsNotResolvableException {
        if (type == null) {
            String msg = CommonPlugin.Util.getString("ERR.003.001.0015", new Object[]{defn.getID(), defn.getComponentTypeID()});
            System.err.print(msg);
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0015", (Object)msg);
        }
        if (!defn.getComponentTypeID().equals(type.getID())) {
            String msg = CommonPlugin.Util.getString("ERR.003.001.0015", new Object[]{defn.getID(), type.getID()});
            System.err.print(msg);
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0015", (Object)msg);
        }
        if (!type.isOfTypeConnector()) {
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0017", (Object)CommonPlugin.Util.getString("ERR.003.001.0017", type.getSuperComponentTypeID().getName()));
        }
    }

    public void resolveConfigurationObjects(Collection collection) throws ConfigObjectsNotResolvableException {
        List[] lists = this.segregateConfigurationObjects(collection);
        this.resolveConfigurationObjects(lists);
    }

    protected void resolveConfigurationObjects(List[] lists) throws ConfigObjectsNotResolvableException {
        ComponentObject config;
        ComponentObject defn;
        List configurations = lists[0];
        List hosts = lists[2];
        List deployedComponents = lists[3];
        List serviceComponentDefns = lists[4];
        List vmComponentDefns = lists[5];
        List componentTypes = lists[6];
        List productServiceConfigs = lists[7];
        List connectionPools = lists[16];
        List resources = lists[18];
        List connectorBindings = lists[19];
        List configurationIDs = lists[8];
        List productTypeIDs = lists[9];
        List hostIDs = lists[10];
        List serviceComponentDefnIDs = lists[12];
        List vmComponentDefnIDs = lists[13];
        List componentTypeIDs = lists[14];
        List productServiceConfigIDs = lists[15];
        List connectorBindingsIDs = lists[20];
        serviceComponentDefnIDs.add(null);
        connectorBindingsIDs.add(null);
        productServiceConfigIDs.add(null);
        productTypeIDs.add(null);
        componentTypeIDs.add(null);
        Iterator iterator = deployedComponents.iterator();
        while (iterator.hasNext()) {
            DeployedComponent deployedComponent = (DeployedComponent)iterator.next();
            if (!vmComponentDefnIDs.contains(deployedComponent.getVMComponentDefnID())) {
                this.throwObjectsNotResolvable(deployedComponent, deployedComponent.getVMComponentDefnID(), "vm component");
            }
            if (!serviceComponentDefnIDs.contains(deployedComponent.getServiceComponentDefnID()) && !connectorBindingsIDs.contains(deployedComponent.getServiceComponentDefnID())) {
                this.throwObjectsNotResolvable(deployedComponent, deployedComponent.getServiceComponentDefnID(), "service component");
            }
            if (!hostIDs.contains(deployedComponent.getHostID())) {
                this.throwObjectsNotResolvable(deployedComponent, deployedComponent.getHostID(), "host");
            }
            if (!productServiceConfigIDs.contains(deployedComponent.getProductServiceConfigID())) {
                this.throwObjectsNotResolvable(deployedComponent, deployedComponent.getProductServiceConfigID(), "psc");
            }
            this.checkComponentTypeID(deployedComponent, componentTypeIDs, productTypeIDs);
        }
        iterator = resources.iterator();
        while (iterator.hasNext()) {
            defn = (SharedResource)iterator.next();
            this.checkComponentTypeID(defn, componentTypeIDs);
        }
        iterator = connectionPools.iterator();
        while (iterator.hasNext()) {
            defn = (ResourceDescriptor)iterator.next();
            this.checkComponentTypeID(defn, componentTypeIDs);
            this.checkConfigurationID((ComponentDefn)defn, configurationIDs);
        }
        iterator = connectorBindings.iterator();
        while (iterator.hasNext()) {
            defn = (ConnectorBinding)iterator.next();
            this.checkComponentTypeID(defn, componentTypeIDs);
        }
        iterator = serviceComponentDefns.iterator();
        while (iterator.hasNext()) {
            defn = (ServiceComponentDefn)iterator.next();
            this.checkComponentTypeID(defn, componentTypeIDs, productTypeIDs);
            this.checkConfigurationID((ComponentDefn)defn, configurationIDs);
        }
        iterator = vmComponentDefns.iterator();
        while (iterator.hasNext()) {
            defn = (VMComponentDefn)iterator.next();
            this.checkComponentTypeID(defn, componentTypeIDs, productTypeIDs);
            this.checkConfigurationID((ComponentDefn)defn, configurationIDs);
        }
        iterator = productServiceConfigs.iterator();
        while (iterator.hasNext()) {
            config = (ProductServiceConfig)iterator.next();
            this.checkPSCProductTypeID((ProductServiceConfig)config, productTypeIDs);
            this.checkConfigurationID((ComponentDefn)config, configurationIDs);
            Iterator iter = config.getServiceComponentDefnIDs().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (serviceComponentDefnIDs.contains(obj) || connectorBindingsIDs.contains(obj)) continue;
                this.throwObjectsNotResolvable(obj, config, "service component");
            }
        }
        iterator = componentTypes.iterator();
        while (iterator.hasNext()) {
            ComponentType type = (ComponentType)iterator.next();
            this.checkForComponentTypeID(type.getSuperComponentTypeID(), componentTypeIDs);
            this.checkForProductTypeID(type, type.getParentComponentTypeID(), productTypeIDs, componentTypeIDs);
        }
        iterator = configurations.iterator();
        while (iterator.hasNext()) {
            config = (Configuration)iterator.next();
            this.checkComponentTypeID(config, componentTypeIDs, productTypeIDs);
        }
        iterator = hosts.iterator();
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            this.checkComponentTypeID(host, componentTypeIDs, productTypeIDs);
        }
    }

    private void throwObjectsNotResolvable(Object referencingObject, Object referencedObject, String type) throws ConfigObjectsNotResolvableException {
        String msg = CommonPlugin.Util.getString("ERR.003.001.0018", new Object[]{referencingObject, type, referencedObject});
        ConfigObjectsNotResolvableException e2 = new ConfigObjectsNotResolvableException("ERR.003.001.0018", msg, referencingObject);
        throw e2;
    }

    private void throwObjectsNotResolvable(Object referencingObject, String type) throws ConfigObjectsNotResolvableException {
        String msg = CommonPlugin.Util.getString("ERR.003.001.0019", new Object[]{referencingObject, type});
        ConfigObjectsNotResolvableException e2 = new ConfigObjectsNotResolvableException("ERR.003.001.0019", msg, referencingObject);
        throw e2;
    }

    private void checkComponentTypeID(ComponentObject object, List componentTypeIDs, List productTypeIDs) throws ConfigObjectsNotResolvableException {
        if (!componentTypeIDs.contains(object.getComponentTypeID()) && !productTypeIDs.contains(object.getComponentTypeID())) {
            this.throwObjectsNotResolvable(object, object.getComponentTypeID(), "component type");
        }
    }

    private void checkConfigurationID(ComponentDefn defn, List configurationIDs) throws ConfigObjectsNotResolvableException {
        if (!configurationIDs.contains(defn.getConfigurationID())) {
            this.throwObjectsNotResolvable(defn, defn.getConfigurationID(), "configuration object");
        }
    }

    private void checkComponentTypeID(ComponentObject object, List componentTypeIDs) throws ConfigObjectsNotResolvableException {
        if (!componentTypeIDs.contains(object.getComponentTypeID())) {
            this.throwObjectsNotResolvable(object, object.getComponentTypeID(), "component type");
        }
    }

    private void checkPSCProductTypeID(ProductServiceConfig object, List productTypeIDs) throws ConfigObjectsNotResolvableException {
        if (!productTypeIDs.contains(object.getComponentTypeID())) {
            this.throwObjectsNotResolvable(object, object.getComponentTypeID(), "component type");
        }
    }

    private void checkForComponentTypeID(ComponentTypeID id, List componentTypeIDs) throws ConfigObjectsNotResolvableException {
        if (id != null && !componentTypeIDs.contains(id)) {
            this.throwObjectsNotResolvable(id, "component");
        }
    }

    private void checkForProductTypeID(ComponentType type, ComponentTypeID parentid, List productTypeIDs, List componentTypeIDs) throws ConfigObjectsNotResolvableException {
        if (parentid != null && type.isOfTypeConnector() && !productTypeIDs.contains(parentid)) {
            this.throwObjectsNotResolvable(parentid, "product type");
        }
    }

    protected List[] segregateConfigurationObjects(Collection collection) {
        List[] lists = new ArrayList[21];
        Assertion.isNotNull(collection);
        ArrayList componentTypes = new ArrayList();
        ArrayList hosts = new ArrayList();
        ArrayList deployedComponents = new ArrayList();
        ArrayList serviceComponentDefns = new ArrayList();
        ArrayList vmComponentDefns = new ArrayList();
        ArrayList productServiceConfigs = new ArrayList();
        ArrayList configurations = new ArrayList();
        ArrayList productTypes = new ArrayList();
        ArrayList connPools = new ArrayList();
        ArrayList resources = new ArrayList();
        ArrayList bindings = new ArrayList();
        ArrayList<BaseID> componentTypeIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> hostIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> deployedComponentIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> serviceComponentDefnIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> vmComponentDefnIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> productServiceConfigIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> configurationIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> productTypeIDs = new ArrayList<BaseID>();
        ArrayList<BaseID> bindingIDs = new ArrayList<BaseID>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof ProductType) {
                productTypes.add(obj);
                productTypeIDs.add(((ProductType)obj).getID());
                continue;
            }
            if (obj instanceof ComponentType) {
                componentTypes.add(obj);
                componentTypeIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (!(obj instanceof ComponentObject)) continue;
            if (obj instanceof Host) {
                hosts.add(obj);
                hostIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (obj instanceof DeployedComponent) {
                deployedComponents.add(obj);
                deployedComponentIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (obj instanceof Configuration) {
                configurations.add(obj);
                configurationIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (obj instanceof SharedResource) {
                resources.add(obj);
                continue;
            }
            if (obj instanceof ConnectorBinding) {
                bindings.add(obj);
                bindingIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (!(obj instanceof ComponentDefn)) continue;
            if (obj instanceof ProductServiceConfig) {
                productServiceConfigs.add(obj);
                productServiceConfigIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (obj instanceof ServiceComponentDefn) {
                serviceComponentDefns.add(obj);
                serviceComponentDefnIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (obj instanceof VMComponentDefn) {
                vmComponentDefns.add(obj);
                vmComponentDefnIDs.add(((BaseObject)obj).getID());
                continue;
            }
            if (!(obj instanceof ResourceDescriptor)) continue;
            connPools.add(obj);
        }
        lists[0] = configurations;
        lists[1] = productTypes;
        lists[2] = hosts;
        lists[3] = deployedComponents;
        lists[4] = serviceComponentDefns;
        lists[5] = vmComponentDefns;
        lists[6] = componentTypes;
        lists[7] = productServiceConfigs;
        lists[8] = configurationIDs;
        lists[9] = productTypeIDs;
        lists[10] = hostIDs;
        lists[11] = deployedComponentIDs;
        lists[12] = serviceComponentDefnIDs;
        lists[13] = vmComponentDefnIDs;
        lists[14] = componentTypeIDs;
        lists[15] = productServiceConfigIDs;
        lists[16] = connPools;
        lists[18] = resources;
        lists[19] = bindings;
        lists[20] = bindingIDs;
        return lists;
    }

    protected XMLReaderWriter getXMLReaderWriter() {
        if (this.readerWriter == null) {
            this.readerWriter = new XMLReaderWriterImpl();
        }
        return this.readerWriter;
    }

    protected abstract XMLHelper getXMLHelper();
}

