/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerImpl;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;

public class ConfigurationModelContainerAdapter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationModelContainer readConfigurationModel(String file, ConfigurationID configID) throws ConfigurationException {
        ConfigurationModelContainer configurationModelContainer;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                configurationModelContainer = this.readConfigurationModel(fis, configID);
                Object var6_7 = null;
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                throw new ConfigurationException((Throwable)ioe, "ERR.003.001.0099", CommonPlugin.Util.getString("ERR.003.001.0099", configID.getFullName()));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return configurationModelContainer;
        }
        if (fis == null) return configurationModelContainer;
        fis.close();
        return configurationModelContainer;
    }

    public ConfigurationModelContainer readConfigurationModel(InputStream inputStream, ConfigurationID configID) throws ConfigurationException {
        Collection configObjects = null;
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        try {
            XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
            configObjects = io.importConfigurationObjects(inputStream, editor, configID.getFullName());
            ConfigurationModelContainerImpl configModel = new ConfigurationModelContainerImpl();
            configModel.setConfigurationObjects(configObjects);
            return configModel;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ConfigurationException((Throwable)ioe, "ERR.003.001.0099", CommonPlugin.Util.getString("ERR.003.001.0099", configID.getFullName()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeConfigurationModel(String file, ConfigurationModelContainer model, String principalName) throws ConfigurationException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                this.writeConfigurationModel(fos, model, principalName);
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                throw new ConfigurationException((Throwable)ioe, "ERR.003.001.0100", CommonPlugin.Util.getString("ERR.003.001.0100", model.getConfiguration().getID()));
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e2) {}
        if (fos == null) return;
        fos.close();
        return;
    }

    public void writeConfigurationModel(OutputStream out, ConfigurationModelContainer model, String principalName) throws ConfigurationException {
        try {
            XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
            Properties props = new Properties();
            props.put("ApplicationCreatedBy", "Configuration Import_Export Utility");
            props.put("ApplicationVersion", "5.0");
            props.put("UserCreatedBy", principalName);
            io.exportConfiguration(out, model.getAllObjects(), props);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ConfigurationException((Throwable)ioe, "ERR.003.001.0100", CommonPlugin.Util.getString("ERR.003.001.0100", model.getConfiguration().getID()));
        }
    }

    public void validateModel(ConfigurationModelContainer model) throws ConfigObjectsNotResolvableException {
        XMLConfigurationImportExportUtility io = new XMLConfigurationImportExportUtility();
        io.resolveConfigurationObjects(model.getAllObjects());
    }
}

