/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import java.io.Serializable;

public class BasicVMComponentDefn
extends BasicComponentDefn
implements VMComponentDefn,
Serializable {
    private HostID hostID;

    public BasicVMComponentDefn(ConfigurationID configurationID, HostID hostID, VMComponentDefnID componentID, ComponentTypeID typeID) {
        super(configurationID, componentID, typeID);
        this.hostID = hostID;
    }

    protected BasicVMComponentDefn(BasicVMComponentDefn component) {
        super(component);
        this.hostID = component.getHostID();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new BasicVMComponentDefn(this);
    }

    public HostID getHostID() {
        return this.hostID;
    }

    public boolean isEnabled() {
        String enabled = this.getProperty("vm.enabled");
        if (enabled == null || enabled.length() == 0) {
            return true;
        }
        return enabled.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public String getPort() {
        return this.getProperty("vm.socketPort");
    }

    public String getBindAddress() {
        String address = this.getProperty("vm.bind.address");
        if (address == null || address.length() == 0) {
            return "";
        }
        return address;
    }
}

