/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.core.util.FileUtils;
import java.io.Serializable;

public class BasicHost
extends BasicComponentDefn
implements Host,
Serializable {
    public BasicHost(ConfigurationID configID, HostID hostID, ComponentTypeID typeID) {
        super(configID, hostID, typeID);
    }

    protected BasicHost(BasicHost component) {
        super(component);
    }

    public String getDataDirectory() {
        return this.getProperty("metamatrix.data.dir");
    }

    public String getLogDirectory() {
        return this.getProperty("metamatrix.log.dir");
    }

    public String getTempDirectory() {
        String datadir = this.getDataDirectory();
        return FileUtils.buildDirectoryPath(new String[]{datadir, "temp"});
    }

    public String getPort() {
        return this.getProperty("hostControllerPortNumber");
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new BasicHost(this);
    }

    public String getBindAddress() {
        String address = this.getProperty("metamatrix.host.bind.address");
        if (address == null || address.length() == 0) {
            return this.getFullName();
        }
        return address;
    }

    public String getHostAddress() {
        String address = this.getProperty("metamatrix.host.physical.address");
        if (address == null || address.length() == 0) {
            return this.getFullName();
        }
        return address;
    }
}

