/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationInfo;
import com.metamatrix.common.namedobject.BasicObject;
import java.io.Serializable;
import java.util.Date;

public class BasicConfigurationInfo
extends BasicObject
implements ConfigurationInfo,
Serializable {
    private boolean isDeployed;
    private boolean isReleased;
    private boolean isLocked;
    private Date creationDate = new Date();
    private Date lastChangedDate;

    public BasicConfigurationInfo(ConfigurationID id) {
        super(id);
    }

    BasicConfigurationInfo(BasicConfigurationInfo info) {
        super(info.getID());
        this.isDeployed = info.isDeployed();
        this.isReleased = info.isReleased();
        this.isLocked = info.isLocked();
        this.creationDate = info.getCreationDate();
        this.lastChangedDate = info.getLastChangedDate();
    }

    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isDeployed() {
        return this.isDeployed;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    void setName(String name) {
        ConfigurationID id = new ConfigurationID(name);
        this.setID(id);
    }

    void setIsDeployed(boolean deploy) {
        this.isDeployed = deploy;
    }

    void setIsLocked(boolean locked) {
        this.isLocked = locked;
    }

    void setIsReleased(boolean release) {
        this.isReleased = release;
    }

    void setCreationDate(Date created) {
        this.creationDate = created;
    }

    void setLastChangedDate(Date lastChanged) {
        this.lastChangedDate = lastChanged;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new BasicConfigurationInfo(this);
    }
}

