/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.mru;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.mru.AgeAndCostValueHolder;
import com.metamatrix.common.cache.mru.AgeMRUCacheHelper;
import com.metamatrix.common.cache.policy.ObjectCacheCostCalculator;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.Properties;

public class AgeAndCostMRUCacheHelper
extends AgeMRUCacheHelper {
    private ObjectCacheCostCalculator costCalculator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties env) throws ObjectCacheException {
        super.initialize(env);
        String calculatorClassName = null;
        Properties properties = env;
        synchronized (properties) {
            calculatorClassName = env.getProperty("com.metamatrix.common.cache.ObjectCache.CostCalculatorClass");
        }
        try {
            this.costCalculator = (ObjectCacheCostCalculator)ReflectionHelper.create(calculatorClassName, null, this.getClass().getClassLoader());
        }
        catch (Exception e2) {
            throw new ObjectCacheException(e2, "ERR.003.008.0015", CommonPlugin.Util.getString("ERR.003.008.0015", calculatorClassName == null ? "NullClassName" : calculatorClassName));
        }
    }

    public Object getValueHolder(Object value) {
        long cost = this.costCalculator.computeCost(value);
        return new AgeAndCostValueHolder(value, cost);
    }

    public long getValueCost(Object valueHolder) {
        AgeAndCostValueHolder holder = (AgeAndCostValueHolder)valueHolder;
        return holder.getCost();
    }

    protected ObjectCacheCostCalculator getCostCalculator() {
        return this.costCalculator;
    }
}

