/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.impl.BatchComparator;
import com.metamatrix.common.buffer.impl.BufferConfig;
import com.metamatrix.common.buffer.impl.BufferStats;
import com.metamatrix.common.buffer.impl.ManagedBatch;
import com.metamatrix.common.buffer.impl.TupleGroupInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MemoryState {
    static final int MEMORY_AVAILABLE = 1;
    static final int MEMORY_EXCEED_MAX = 2;
    static final int MEMORY_EXCEED_SESSION_MAX = 3;
    private BufferConfig config;
    private long memoryUsed = 0L;
    private Map pinned = new HashMap();
    private static final Comparator BATCH_COMPARATOR = new BatchComparator();
    private List unpinned = new ArrayList();

    public MemoryState(BufferConfig config) {
        this.config = config;
    }

    public synchronized void fillStats(BufferStats stats) {
        stats.memoryUsed = this.memoryUsed;
        stats.memoryFree = this.config.getTotalAvailableMemory() - this.memoryUsed;
    }

    public synchronized long getMemoryUsed() {
        return this.memoryUsed;
    }

    public synchronized int reserveMemory(long bytes, TupleGroupInfo groupInfo) {
        long sessionMax = this.config.getMaxAvailableSession();
        if (sessionMax - groupInfo.getGroupMemoryUsed() < bytes) {
            return 3;
        }
        long max = this.config.getTotalAvailableMemory();
        if (max - this.memoryUsed < bytes) {
            return 2;
        }
        groupInfo.reserveMemory(bytes);
        this.memoryUsed += bytes;
        return 1;
    }

    public synchronized void releaseMemory(long bytes, TupleGroupInfo groupInfo) {
        groupInfo.releaseMemory(bytes);
        this.memoryUsed -= bytes;
    }

    public synchronized long getGroupMemoryUsed(TupleGroupInfo groupInfo) {
        return groupInfo.getGroupMemoryUsed();
    }

    public synchronized void addPinned(ManagedBatch batch) {
        TupleSourceID tsID = batch.getTupleSourceID();
        HashMap<Integer, ManagedBatch> tsPinned = (HashMap<Integer, ManagedBatch>)this.pinned.get(tsID);
        if (tsPinned == null) {
            tsPinned = new HashMap<Integer, ManagedBatch>();
            this.pinned.put(tsID, tsPinned);
        }
        tsPinned.put(new Integer(batch.getBeginRow()), batch);
    }

    public synchronized ManagedBatch removePinned(TupleSourceID tsID, int beginRow) {
        Map tsPinned = (Map)this.pinned.get(tsID);
        if (tsPinned != null) {
            ManagedBatch mbatch = (ManagedBatch)tsPinned.remove(new Integer(beginRow));
            if (tsPinned.size() == 0) {
                this.pinned.remove(tsID);
            }
            return mbatch;
        }
        return null;
    }

    public synchronized void addUnpinned(ManagedBatch batch) {
        int size;
        batch.updateLastAccessed();
        if (this.unpinned.isEmpty()) {
            this.unpinned.add(batch);
            return;
        }
        for (int i2 = size = this.unpinned.size() - 1; i2 >= 0; --i2) {
            ManagedBatch listBatch = (ManagedBatch)this.unpinned.get(i2);
            if (BATCH_COMPARATOR.compare(batch, listBatch) < 0) continue;
            this.unpinned.add(i2 + 1, batch);
            break;
        }
    }

    public synchronized void removeUnpinned(ManagedBatch batch) {
        this.unpinned.remove(batch);
    }

    public synchronized Iterator getAllUnpinned() {
        ArrayList copy = new ArrayList(this.unpinned);
        return copy.iterator();
    }
}

