/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import java.util.Properties;

public class BufferConfig {
    private long totalAvailableMemory = 100000000L;
    private int groupUsePercentage = 80;
    private int activeMemoryThreshold = 75;
    private int managementInterval = 500;
    private int connectorBatchSize = 1000;
    private int processorBatchSize = 100;
    private String bufferStorageDirectory = "../buffer";
    private int logStatInterval = 0;
    private long availableSessionLevel = 0L;
    private long activeMemoryLevel = 0L;

    public BufferConfig() {
        this.computeDerived();
    }

    public BufferConfig(Properties props) {
        String propStr;
        try {
            propStr = props.getProperty("metamatrix.buffer.memoryAvailable");
            if (propStr != null) {
                this.totalAvailableMemory = (long)Integer.parseInt(propStr) * 1000000L;
            }
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.sessionUsePercentage");
            if (propStr != null) {
                this.groupUsePercentage = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException e3) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.activeMemoryThreshold");
            if (propStr != null) {
                this.activeMemoryThreshold = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException e4) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.managementInterval");
            if (propStr != null) {
                this.managementInterval = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException e5) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.connectorBatchSize");
            if (propStr != null) {
                this.connectorBatchSize = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException e6) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.processorBatchSize");
            if (propStr != null) {
                this.processorBatchSize = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException e7) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.storageDirectory");
            if (propStr != null) {
                this.bufferStorageDirectory = propStr;
            }
        }
        catch (NumberFormatException e8) {
            // empty catch block
        }
        try {
            propStr = props.getProperty("metamatrix.buffer.logStatsInterval");
            if (propStr != null) {
                this.logStatInterval = Integer.parseInt(propStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.computeDerived();
    }

    public long getTotalAvailableMemory() {
        return this.totalAvailableMemory;
    }

    public void setTotalAvailableMemory(long totalAvailableMemory) {
        this.totalAvailableMemory = totalAvailableMemory;
        this.computeDerived();
    }

    public int getGroupUsePercentage() {
        return this.groupUsePercentage;
    }

    public void setGroupUsePercentage(int groupUsePercentage) {
        this.groupUsePercentage = groupUsePercentage;
        this.computeDerived();
    }

    public int getActiveMemoryThreshold() {
        return this.activeMemoryThreshold;
    }

    public void setActiveMemoryThreshold(int activeMemoryThreshold) {
        this.activeMemoryThreshold = activeMemoryThreshold;
        this.computeDerived();
    }

    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.connectorBatchSize = connectorBatchSize;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    public int getManagementInterval() {
        return this.managementInterval;
    }

    public void setManagementInterval(int managementInterval) {
        this.managementInterval = managementInterval;
    }

    public String getBufferStorageDirectory() {
        return this.bufferStorageDirectory;
    }

    public void setBufferStorageDirectory(String bufferStorageDirectory) {
        this.bufferStorageDirectory = bufferStorageDirectory;
    }

    public int getLogStatInterval() {
        return this.logStatInterval;
    }

    public void setStatUpdateInterval(int logStatInterval) {
        this.logStatInterval = logStatInterval;
    }

    private void computeDerived() {
        this.availableSessionLevel = (int)((double)this.totalAvailableMemory * ((double)this.groupUsePercentage / 100.0));
        this.activeMemoryLevel = (int)((double)this.totalAvailableMemory * ((double)this.activeMemoryThreshold / 100.0));
    }

    public long getMaxAvailableSession() {
        return this.availableSessionLevel;
    }

    public long getActiveMemoryLevel() {
        return this.activeMemoryLevel;
    }
}

