/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.actions.AttributeDefinition;
import java.io.Serializable;
import java.util.Date;

public abstract class ActionDefinition
implements Cloneable,
Serializable {
    private Object target;
    private long creationTime;
    private Object[] arguments;
    private Integer attributeCode;
    private String attributeDescription;

    public ActionDefinition() {
        this.creationTime = System.currentTimeMillis();
    }

    public ActionDefinition(Object[] arguments) {
        this.creationTime = System.currentTimeMillis();
        this.arguments = arguments;
    }

    public ActionDefinition(Object target, AttributeDefinition attribute, Object[] arguments) {
        this.creationTime = System.currentTimeMillis();
        this.target = target;
        if (attribute != null) {
            this.attributeCode = new Integer(attribute.getCode());
            this.attributeDescription = attribute.getLabel();
        }
        this.arguments = arguments;
    }

    public ActionDefinition(Object target, AttributeDefinition attribute) {
        this(target, attribute, null);
    }

    protected ActionDefinition(Object target, Integer code) {
        this(target, code, null, System.currentTimeMillis());
    }

    protected ActionDefinition(Object target, Integer code, Object[] arguments, long creationTime) {
        this.creationTime = creationTime;
        this.target = target;
        this.attributeCode = code;
        this.arguments = arguments;
    }

    protected ActionDefinition(Object target, Integer code, Object[] arguments) {
        this.creationTime = System.currentTimeMillis();
        this.target = target;
        this.attributeCode = code;
        this.arguments = arguments;
    }

    protected ActionDefinition(ActionDefinition rhs) {
        this.creationTime = rhs.creationTime;
        this.target = rhs.target;
        this.attributeCode = rhs.attributeCode;
        this.arguments = rhs.arguments;
    }

    public Date getCreationTime() {
        return new Date(this.creationTime);
    }

    public long getCreationTimeMillis() {
        return this.creationTime;
    }

    public abstract String getActionDescription();

    public abstract Object clone();

    public String toString() {
        return this.getActionDescription();
    }

    public abstract ActionDefinition getUndoActionDefinition();

    public final boolean hasTarget() {
        return this.target != null;
    }

    public final boolean hasArguments() {
        return this.arguments != null && this.arguments.length != 0;
    }

    public final boolean hasAttributeCode() {
        return this.attributeCode != null;
    }

    public final String getAttributeDescription() {
        return this.attributeDescription != null ? this.attributeDescription : "";
    }

    public final Object getTarget() {
        return this.target;
    }

    public final Integer getAttributeCode() {
        return this.attributeCode;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

