/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.exception;

import com.metamatrix.api.exception.MetaMatrixExceptionUtil;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.MetaMatrixCoreException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;

public class MetaMatrixException
extends MetaMatrixCoreException
implements Serializable,
MetaMatrixExceptionUtil.MessageFormatter {
    private String code;
    private String msg;

    public static String getClassShortName(Class cls) {
        if (cls == null) {
            return "";
        }
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public MetaMatrixException() {
    }

    public MetaMatrixException(String message) {
        super(message);
        this.setMessage(message);
    }

    public MetaMatrixException(String code, String message) {
        this(message);
        this.setCode(code);
    }

    public MetaMatrixException(Throwable e2) {
        this(e2, e2 == null ? null : e2.getMessage());
    }

    public MetaMatrixException(Throwable e2, String message) {
        super(e2, message);
        if (e2 instanceof MetaMatrixException) {
            this.setCode(((MetaMatrixException)e2).getCode());
        } else if (e2 instanceof MetaMatrixRuntimeException) {
            this.setCode(Integer.toString(((MetaMatrixRuntimeException)e2).getCode()));
        }
        this.setMessage(message);
    }

    public MetaMatrixException(Throwable e2, String code, String message) {
        this(e2, message);
        this.setCode(code);
    }

    public Throwable getChild() {
        return super.getException();
    }

    public Iterator getChildren() {
        return new MetaMatrixExceptionUtil.NestedExceptionIterator(this);
    }

    public String getCode() {
        return this.code;
    }

    public String getFormattedMessage(Throwable throwable, int level) {
        String code = throwable instanceof MetaMatrixException ? ((MetaMatrixException)throwable).getCode() : (throwable instanceof MetaMatrixRuntimeException ? Integer.toString(((MetaMatrixRuntimeException)throwable).getCode()) : null);
        return (level != 0 ? CommonPlugin.Util.getString("MetaMatrixException._n_2") + level + " " : "") + "[" + MetaMatrixException.getClassShortName(throwable.getClass()) + "]" + (code != null ? ' ' + code + ": " : "") + (throwable.getMessage() == null ? "" : throwable.getMessage());
    }

    public String getFullMessage() {
        return MetaMatrixExceptionUtil.getLinkedMessages(this, 0, this);
    }

    public String getMessage() {
        return this.msg;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private void setMessage(String message) {
        this.msg = message;
    }

    public String toString() {
        return this.getFullMessage();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.code = (String)in.readObject();
        this.msg = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.code);
        out.writeObject(this.msg);
    }
}

