/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.xmi;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.internal.core.xml.JdomHelper;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public final class XMIHeader {
    public static final String DEFAULT_INDENT = "  ";
    private Documentation documentation = new Documentation();
    private List models = new ArrayList();
    private List metamodels = new ArrayList();
    private List metametamodels = new ArrayList();
    private List imports = new ArrayList();

    public Documentation getDocumentation() {
        return this.documentation;
    }

    public Collection getModels() {
        return this.models;
    }

    public Collection getMetaModels() {
        return this.metamodels;
    }

    public Collection getMetaMetaModels() {
        return this.metametamodels;
    }

    public Collection getImports() {
        return this.imports;
    }

    public void addModel(String name, String version, String href) {
        this.models.add(new Model(name, version, href));
    }

    public void addModel(String name, String version, String href, String content) {
        this.models.add(new Model(name, version, href, content));
    }

    public void addMetaModel(String name, String version, String href) {
        this.metamodels.add(new MetaModel(name, version, href));
    }

    public void addMetaModel(String name, String version, String href, String content) {
        this.metamodels.add(new MetaModel(name, version, href, content));
    }

    public void addMetaMetaModel(String name, String version, String href) {
        this.metametamodels.add(new MetaMetaModel(name, version, href));
    }

    public void addMetaMetaModel(String name, String version, String href, String content) {
        this.metametamodels.add(new MetaMetaModel(name, version, href, content));
    }

    public void addImport(String name, String version, String href) {
        this.imports.add(new Import(name, version, href));
    }

    public void addImport(String name, String version, String href, String content) {
        this.imports.add(new Import(name, version, href, content));
    }

    public String getXMIFragment(String indent, boolean newlines) {
        Document doc = new Document(new Element("XMI"));
        XMIHeader.applyHeader(doc, this);
        try {
            XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat(indent, newlines));
            StringWriter writer = new StringWriter();
            outputter.output(doc, (Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (IOException e2) {
            throw new MetaMatrixRuntimeException((Throwable)e2, "ERR.003.003.0022", CommonPlugin.Util.getString("ERR.003.003.0022"));
        }
    }

    public String getXMIFragment() {
        return this.getXMIFragment(DEFAULT_INDENT, true);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMIHeader)) {
            return false;
        }
        XMIHeader that = (XMIHeader)obj;
        if (!that.getDocumentation().equals(this.documentation)) {
            return false;
        }
        List thatModels = (List)that.getModels();
        if (this.models.size() != thatModels.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.models.size(); ++i2) {
            if (this.models.get(i2).equals(thatModels.get(i2))) continue;
            return false;
        }
        List thatMetamodels = (List)that.getMetaModels();
        if (this.metamodels.size() != thatMetamodels.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.metamodels.size(); ++i3) {
            if (this.metamodels.get(i3).equals(thatMetamodels.get(i3))) continue;
            return false;
        }
        List thatMetametamodels = (List)that.getMetaMetaModels();
        if (this.metametamodels.size() != thatMetametamodels.size()) {
            return false;
        }
        for (int i4 = 0; i4 < this.metametamodels.size(); ++i4) {
            if (this.metametamodels.get(i4).equals(thatMetametamodels.get(i4))) continue;
            return false;
        }
        List thatImports = (List)that.getImports();
        if (this.imports.size() != thatImports.size()) {
            return false;
        }
        for (int i5 = 0; i5 < this.imports.size(); ++i5) {
            if (this.imports.get(i5).equals(thatImports.get(i5))) continue;
            return false;
        }
        return true;
    }

    public static void applyHeader(Document doc, XMIHeader xmiHeader) {
        Element headerTag = new Element("XMI.header");
        doc.setRootElement(headerTag);
        XMIHeader.applyHeader(headerTag, xmiHeader, true);
    }

    public static void applyHeader(Element root, XMIHeader xmiHeader, boolean newDocument) {
        Element headerTag = root;
        if (!newDocument) {
            headerTag = null;
            headerTag = root.getChild("XMI.header");
            Element contentTag = root.getChild("XMI.content");
            if (headerTag != null) {
                root.removeContent(headerTag);
                root.removeContent(contentTag);
            }
            headerTag = new Element("XMI.header");
            root.addContent(headerTag);
            if (contentTag != null) {
                root.addContent(contentTag);
            }
        }
        Element documentation = new Element("XMI.documentation");
        Documentation xmiDoc = xmiHeader.getDocumentation();
        XMIHeader.addElement(documentation, "XMI.owner", xmiDoc.getOwner());
        XMIHeader.addElement(documentation, "XMI.longDescription", xmiDoc.getLongDescription());
        XMIHeader.addElement(documentation, "XMI.shortDescription", xmiDoc.getShortDescription());
        XMIHeader.addElement(documentation, "XMI.contact", xmiDoc.getContact());
        XMIHeader.addElement(documentation, "XMI.exporter", xmiDoc.getExporter());
        XMIHeader.addElement(documentation, "XMI.exporterID", xmiDoc.getExporterID());
        XMIHeader.addElement(documentation, "XMI.exporterVersion", xmiDoc.getExporterVersion());
        XMIHeader.addElement(documentation, "XMI.notice", xmiDoc.getNotice());
        XMIHeader.addText(documentation, xmiDoc.getText());
        if (documentation.getChildren().size() != 0 || documentation.getText().length() != 0) {
            headerTag.addContent(documentation);
        }
        Iterator iter = xmiHeader.getModels().iterator();
        while (iter.hasNext()) {
            XMIHeader.addModel(headerTag, (Model)iter.next());
        }
        iter = xmiHeader.getMetaModels().iterator();
        while (iter.hasNext()) {
            XMIHeader.addModel(headerTag, (Model)iter.next());
        }
        iter = xmiHeader.getMetaMetaModels().iterator();
        while (iter.hasNext()) {
            XMIHeader.addModel(headerTag, (Model)iter.next());
        }
        iter = xmiHeader.getImports().iterator();
        while (iter.hasNext()) {
            XMIHeader.addImport(headerTag, (Import)iter.next());
        }
    }

    protected static boolean addElement(Element parent, String tagName, String text) {
        if (parent == null || text == null || text.length() == 0) {
            return false;
        }
        Element newTag = new Element(tagName);
        newTag.setText(text);
        parent.addContent(newTag);
        return true;
    }

    protected static boolean addText(Element tag, String text) {
        if (tag == null || text == null || text.length() == 0) {
            return false;
        }
        tag.setText(text);
        return true;
    }

    protected static boolean addModel(Element parent, Model model) {
        String content;
        String href;
        String version;
        if (parent == null || model == null) {
            return false;
        }
        String tagName = "XMI.model";
        if (model instanceof MetaModel) {
            tagName = "XMI.metamodel";
        } else if (model instanceof MetaMetaModel) {
            tagName = "XMI.metametamodel";
        }
        Element newTag = new Element(tagName);
        boolean added = false;
        String name = model.getName();
        if (name != null && name.length() != 0) {
            newTag.setAttribute("xmi.name", name);
            added = true;
        }
        if ((version = model.getVersion()) != null && version.length() != 0) {
            newTag.setAttribute("xmi.version", version);
            added = true;
        }
        if ((href = model.getHref()) != null && href.length() != 0) {
            newTag.setAttribute("href", href);
            added = true;
        }
        if ((content = model.getContent()) != null && href != null && href.length() != 0) {
            newTag.addContent(content);
        }
        if (added) {
            parent.addContent(newTag);
        }
        return true;
    }

    protected static boolean addImport(Element parent, Import importObj) {
        String content;
        String href;
        String version;
        if (parent == null || importObj == null) {
            return false;
        }
        Element newTag = new Element("XMI.import");
        boolean added = false;
        String name = importObj.getName();
        if (name != null && name.length() != 0) {
            newTag.setAttribute("xmi.name", name);
            added = true;
        }
        if ((version = importObj.getVersion()) != null && version.length() != 0) {
            newTag.setAttribute("xmi.version", version);
            added = true;
        }
        if ((href = importObj.getHref()) != null && href.length() != 0) {
            newTag.setAttribute("href", href);
            added = true;
        }
        if ((content = importObj.getContent()) != null && content.length() != 0) {
            newTag.addContent(content);
            added = true;
        }
        if (added) {
            parent.addContent(newTag);
        }
        return true;
    }

    public void print(PrintStream stream) {
        Model model;
        stream.println("XMI Header:");
        stream.println("  Documentation");
        Documentation doc = this.getDocumentation();
        stream.println("    Owner:        " + doc.getOwner());
        stream.println("    Contact:      " + doc.getContact());
        stream.println("    Long Desc:    " + doc.getLongDescription());
        stream.println("    Short Desc:   " + doc.getShortDescription());
        stream.println("    Notice:       " + doc.getNotice());
        stream.println("    Exporter:     " + doc.getExporter());
        stream.println("    ExporterID:   " + doc.getExporterID());
        stream.println("    Exporter Ver: " + doc.getExporterVersion());
        stream.println("  Namespaces");
        stream.println("  Models");
        Iterator iter = this.getModels().iterator();
        while (iter.hasNext()) {
            model = (Model)iter.next();
            stream.println("    " + model.getName() + ", " + model.getVersion() + ", " + model.getHref() + ", \"" + model.getContent() + "\"");
        }
        stream.println("  MetaModels");
        iter = this.getMetaModels().iterator();
        while (iter.hasNext()) {
            model = (Model)iter.next();
            stream.println("    " + model.getName() + ", " + model.getVersion() + ", " + model.getHref() + ", \"" + model.getContent() + "\"");
        }
        stream.println("  MetaMetaModels");
        iter = this.getMetaMetaModels().iterator();
        while (iter.hasNext()) {
            model = (Model)iter.next();
            stream.println("    " + model.getName() + ", " + model.getVersion() + ", " + model.getHref() + ", \"" + model.getContent() + "\"");
        }
        stream.println("  Imports");
        iter = this.getImports().iterator();
        while (iter.hasNext()) {
            Import imp = (Import)iter.next();
            stream.println("    " + imp.getName() + ", " + imp.getVersion() + ", " + imp.getHref() + ", \"" + imp.getContent() + "\"");
        }
    }

    public static class Import {
        private String href;
        private String name;
        private String version;
        private String content;

        Import(String name, String version, String href, String content) {
            if (name != null && name.length() != 0) {
                this.name = name;
            }
            if (version != null && version.length() != 0) {
                this.version = version;
            }
            if (href != null && href.length() != 0) {
                this.href = href;
            }
            if (content != null && content.length() != 0) {
                this.content = content;
            }
        }

        Import(String name, String version, String href) {
            this(name, version, href, null);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getContent() {
            if (this.content == null) {
                return "";
            }
            return this.content;
        }

        public void addContent(String content) {
            this.content = content;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Import)) {
                return false;
            }
            Import that = (Import)obj;
            return (that.getHref() == null ? this.getHref() == null : that.getHref().equals(this.getHref())) && (that.getName() == null ? this.getName() == null : that.getName().equals(this.getName())) && (that.getVersion() == null ? this.getVersion() == null : that.getVersion().equals(this.getVersion())) && (that.getContent() == null ? this.getContent() == null : that.getContent().equals(this.getContent()));
        }
    }

    public static class MetaMetaModel
    extends Model {
        MetaMetaModel(String name, String version, String href) {
            super(name, version, href);
        }

        MetaMetaModel(String name, String version, String href, String content) {
            super(name, version, href, content);
        }
    }

    public static class MetaModel
    extends Model {
        MetaModel(String name, String version, String href) {
            super(name, version, href);
        }

        MetaModel(String name, String version, String href, String content) {
            super(name, version, href, content);
        }
    }

    public static class Model {
        private String href;
        private String name;
        private String version;
        private String content;

        Model(String name, String version, String href, String content) {
            if (name != null && name.length() != 0) {
                this.name = name;
            }
            if (version != null && version.length() != 0) {
                this.version = version;
            }
            if (href != null && href.length() != 0) {
                this.href = href;
            }
            if (content != null && content.length() != 0) {
                this.content = content;
            }
        }

        Model(String name, String version, String href) {
            this(name, version, href, null);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getContent() {
            if (this.content == null) {
                return "";
            }
            return this.content;
        }

        public void addContent(String content) {
            this.content = content;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Model)) {
                return false;
            }
            Model that = (Model)obj;
            return (that.getHref() == null ? this.getHref() == null : that.getHref().equals(this.getHref())) && (that.getName() == null ? this.getName() == null : that.getName().equals(this.getName())) && (that.getVersion() == null ? this.getVersion() == null : that.getVersion().equals(this.getVersion())) && (that.getContent() == null ? this.getContent() == null : that.getContent().equals(this.getContent()));
        }
    }

    public static class Documentation {
        private String owner;
        private String contact;
        private String longDescription;
        private String shortDescription;
        private String exporter;
        private String exporterVersion;
        private String exporterID;
        private String notice;
        private String text;

        Documentation() {
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getContact() {
            return this.contact;
        }

        public void setContact(String contact) {
            this.contact = contact;
        }

        public String getLongDescription() {
            return this.longDescription;
        }

        public void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public String getExporter() {
            return this.exporter;
        }

        public void setExporter(String exporter) {
            this.exporter = exporter;
        }

        public String getExporterVersion() {
            return this.exporterVersion;
        }

        public void setExporterVersion(String exporterVersion) {
            this.exporterVersion = exporterVersion;
        }

        public String getExporterID() {
            return this.exporterID;
        }

        public void setExporterID(String exporterID) {
            this.exporterID = exporterID;
        }

        public String getNotice() {
            return this.notice;
        }

        public void setNotice(String notice) {
            this.notice = notice;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Documentation)) {
                return false;
            }
            Documentation that = (Documentation)obj;
            return (that.getOwner() == null ? this.owner == null : that.getOwner().equals(this.owner)) && (that.getContact() == null ? this.contact == null : that.getContact().equals(this.contact)) && (that.getLongDescription() == null ? this.longDescription == null : that.getLongDescription().equals(this.longDescription)) && (that.getShortDescription() == null ? this.shortDescription == null : that.getShortDescription().equals(this.shortDescription)) && (that.getExporter() == null ? this.exporter == null : that.getExporter().equals(this.exporter)) && (that.getExporterVersion() == null ? this.exporterVersion == null : that.getExporterVersion().equals(this.exporterVersion)) && (that.getExporterID() == null ? this.exporterID == null : that.getExporterID().equals(this.exporterID)) && (that.getNotice() == null ? this.notice == null : that.getNotice().equals(this.notice)) && (that.getText() == null ? this.text == null : that.getText().equals(this.text));
        }
    }
}

