/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.DefaultProgressMonitor;
import com.metamatrix.api.core.message.ProgressMonitor;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.util.Assertion;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamProgressMonitor
extends FilterInputStream {
    private final DefaultProgressMonitor monitor;
    private long recordedProgress;
    private boolean completeOnEOS;

    public InputStreamProgressMonitor(InputStream stream, DefaultProgressMonitor monitor) {
        this(stream, monitor, true);
    }

    public InputStreamProgressMonitor(InputStream stream, DefaultProgressMonitor monitor, boolean completeOnEOS) {
        super(stream);
        if (stream == null) {
            Assertion.isNotNull(stream, CommonPlugin.Util.getString("ERR.003.003.0009"));
        }
        if (monitor == null) {
            Assertion.isNotNull(monitor, CommonPlugin.Util.getString("ERR.003.003.0010"));
        }
        this.monitor = monitor;
        this.completeOnEOS = completeOnEOS;
    }

    protected void addWorkToMonitor(long bytes) throws IOException {
        this.monitor.addWork(bytes);
    }

    public int read() throws IOException {
        int result = this.in.read();
        if (result == -1) {
            if (this.completeOnEOS) {
                this.monitor.setComplete();
            } else {
                this.addWorkToMonitor(1L);
            }
        } else {
            this.addWorkToMonitor(1L);
        }
        return result;
    }

    public int read(byte[] b2) throws IOException {
        int numBytes = this.in.read(b2);
        if (numBytes == -1) {
            if (this.completeOnEOS) {
                this.monitor.setComplete();
            } else {
                this.addWorkToMonitor(1L);
            }
        } else {
            this.addWorkToMonitor(numBytes);
        }
        return numBytes;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int numBytes = this.in.read(b2, off, len);
        if (numBytes == -1) {
            if (this.completeOnEOS) {
                this.monitor.setComplete();
            } else {
                this.addWorkToMonitor(1L);
            }
        } else {
            this.addWorkToMonitor(numBytes);
        }
        return numBytes;
    }

    public long skip(long n2) throws IOException {
        long numBytesSkipped = this.in.skip(n2);
        this.addWorkToMonitor(numBytesSkipped);
        return numBytesSkipped;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.recordedProgress = this.monitor.getWork();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.monitor.setWork(this.recordedProgress);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }
}

