/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class PropertyChangeMulticaster
implements Serializable {
    protected transient PropertyChangeListener[] listeners = new PropertyChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized PropertyChangeMulticaster getChild(String string) {
        return this.children == null ? null : (PropertyChangeMulticaster)this.children.get(string);
    }

    public PropertyChangeMulticaster(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        int n2 = this.listeners.length;
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n2 + 1];
        if (n2 > 0) {
            System.arraycopy(this.listeners, 0, propertyChangeListenerArray, 0, n2);
        }
        propertyChangeListenerArray[n2] = propertyChangeListener;
        this.listeners = propertyChangeListenerArray;
    }

    public synchronized void addPropertyChangeListenerIfAbsent(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        int n2 = this.listeners.length;
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            propertyChangeListenerArray[i2] = this.listeners[i2];
            if (!propertyChangeListener.equals(this.listeners[i2])) continue;
            return;
        }
        propertyChangeListenerArray[n2] = propertyChangeListener;
        this.listeners = propertyChangeListenerArray;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n2 = this.listeners.length - 1;
        if (n2 < 0 || propertyChangeListener == null) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (propertyChangeListener.equals(this.listeners[i2])) {
                for (int i3 = i2 + 1; i3 <= n2; ++i3) {
                    propertyChangeListenerArray[i3 - 1] = this.listeners[i3];
                }
                this.listeners = propertyChangeListenerArray;
                return;
            }
            propertyChangeListenerArray[i2] = this.listeners[i2];
        }
        if (propertyChangeListener.equals(this.listeners[n2])) {
            this.listeners = propertyChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            }
            if (propertyChangeMulticaster == null) {
                propertyChangeMulticaster = new PropertyChangeMulticaster(this.source);
                this.children.put(string, propertyChangeMulticaster);
            }
        }
        propertyChangeMulticaster.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListenerIfAbsent(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            }
            if (propertyChangeMulticaster == null) {
                propertyChangeMulticaster = new PropertyChangeMulticaster(this.source);
                this.children.put(string, propertyChangeMulticaster);
            }
        }
        propertyChangeMulticaster.addPropertyChangeListenerIfAbsent(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeMulticaster propertyChangeMulticaster = this.getChild(string);
        if (propertyChangeMulticaster != null) {
            propertyChangeMulticaster.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray;
        PropertyChangeMulticaster propertyChangeMulticaster = null;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            propertyChangeListenerArray = this.listeners;
            if (this.children != null && propertyChangeEvent.getPropertyName() != null) {
                propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(propertyChangeEvent.getPropertyName());
            }
        }
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            propertyChangeListenerArray[i2].propertyChange(propertyChangeEvent);
        }
        if (propertyChangeMulticaster != null) {
            propertyChangeMulticaster.multicast(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(new PropertyChangeEvent(this.source, string, object, object2));
        }
    }

    public void firePropertyChange(String string, int n2, int n3) {
        if (n2 != n3) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Integer(n2), new Integer(n3)));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.multicast(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object == null || object2 == null || !object.equals(object2)) {
            this.multicast(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String string) {
        PropertyChangeMulticaster propertyChangeMulticaster;
        PropertyChangeMulticaster propertyChangeMulticaster2 = this;
        synchronized (propertyChangeMulticaster2) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (string == null || this.children == null) {
                return false;
            }
            propertyChangeMulticaster = (PropertyChangeMulticaster)this.children.get(string);
            if (propertyChangeMulticaster == null) {
                return false;
            }
        }
        return propertyChangeMulticaster.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.listeners.length; ++i2) {
            PropertyChangeListener propertyChangeListener = this.listeners[i2];
            if (!(this.listeners[i2] instanceof Serializable)) continue;
            objectOutputStream.writeObject(this.listeners[i2]);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        this.listeners = new PropertyChangeListener[0];
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

