/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;

public class BoundedBuffer
implements BoundedChannel {
    protected final Object[] array_;
    protected int takePtr_ = 0;
    protected int putPtr_ = 0;
    protected int usedSlots_ = 0;
    protected int emptySlots_;
    protected final Object putMonitor_ = new Object();

    public BoundedBuffer(int n2) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.array_ = new Object[n2];
        this.emptySlots_ = n2;
    }

    public BoundedBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public synchronized int size() {
        return this.usedSlots_;
    }

    public int capacity() {
        return this.array_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incEmptySlots() {
        Object object = this.putMonitor_;
        synchronized (object) {
            ++this.emptySlots_;
            this.putMonitor_.notify();
        }
    }

    protected synchronized void incUsedSlots() {
        ++this.usedSlots_;
        this.notify();
    }

    protected final void insert(Object object) {
        --this.emptySlots_;
        this.array_[this.putPtr_] = object;
        if (++this.putPtr_ >= this.array_.length) {
            this.putPtr_ = 0;
        }
    }

    protected final Object extract() {
        --this.usedSlots_;
        Object object = this.array_[this.takePtr_];
        this.array_[this.takePtr_] = null;
        if (++this.takePtr_ >= this.array_.length) {
            this.takePtr_ = 0;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.usedSlots_ > 0) {
                return this.array_[this.takePtr_];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object2 = this.putMonitor_;
        synchronized (object2) {
            while (this.emptySlots_ <= 0) {
                try {
                    this.putMonitor_.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.putMonitor_.notify();
                    throw interruptedException;
                }
            }
            this.insert(object);
        }
        this.incUsedSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l2) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object2 = this.putMonitor_;
        synchronized (object2) {
            long l3 = l2 <= 0L ? 0L : System.currentTimeMillis();
            long l4 = l2;
            while (this.emptySlots_ <= 0) {
                if (l4 <= 0L) {
                    return false;
                }
                try {
                    this.putMonitor_.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    this.putMonitor_.notify();
                    throw interruptedException;
                }
                l4 = l2 - (System.currentTimeMillis() - l3);
            }
            this.insert(object);
        }
        this.incUsedSlots();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            while (this.usedSlots_ <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            object = this.extract();
        }
        this.incEmptySlots();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            long l3 = l2 <= 0L ? 0L : System.currentTimeMillis();
            long l4 = l2;
            while (this.usedSlots_ <= 0) {
                if (l4 <= 0L) {
                    return null;
                }
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
                l4 = l2 - (System.currentTimeMillis() - l3);
            }
            object = this.extract();
        }
        this.incEmptySlots();
        return object;
    }
}

