/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.lds.servlet.filter;

import com.metamatrix.admin.api.embedded.EmbeddedAdmin;
import com.metamatrix.admin.api.embedded.EmbeddedLogger;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.soap.lds.DataservicePlugin;
import com.metamatrix.soap.lds.connection.DQPConnection;
import com.metamatrix.soap.lds.log.DQPLoggerAdapter;
import com.metamatrix.soap.lds.log.DataserviceFileLogWriter;
import com.metamatrix.soap.lds.log.DataserviceLogger;
import com.metamatrix.soap.lds.util.log.DataServiceLogUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.soap.SOAPException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class DataServiceFilter
implements Filter {
    private static java.sql.Connection connection = null;
    private static String vdbName = "";
    private static String additionalProperties = "";
    private DQPLoggerAdapter dqpLoggerAdapter = null;
    private DataserviceFileLogWriter logWriter = null;
    private DataserviceLogger platformLog = DataserviceLogger.getInstance();
    private static final String WARMUP_QUERY = "SELECT 'X'";

    public void init(FilterConfig config) throws ServletException {
        String logFilePath = config.getServletContext().getInitParameter("LogFilePath");
        String logFilePrefix = config.getServletContext().getInitParameter("LogFilePrefix");
        File log = DataServiceLogUtil.createFilePath((String)logFilePath, (String)logFilePrefix);
        this.logWriter = new DataserviceFileLogWriter(log);
        try {
            log.createNewFile();
        }
        catch (IOException err) {
            this.logWriter.setException((Exception)err);
        }
        this.platformLog.getPlatformLog().addListener((LogListener)this.logWriter);
        this.dqpLoggerAdapter = new DQPLoggerAdapter();
        if (config != null) {
            vdbName = config.getServletContext().getInitParameter("VdbFileName");
            additionalProperties = config.getServletContext().getInitParameter("AdditionalProperties");
            try {
                this.checkConnection();
            }
            catch (SQLException err) {
                this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
            }
            catch (AdminException err) {
                this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
            }
            catch (SOAPException err) {
                this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
            }
            catch (IOException err) {
                this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.checkConnection();
        }
        catch (SQLException err) {
            this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
        }
        catch (AdminException err) {
            this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
        }
        catch (SOAPException err) {
            this.platformLog.getLogFile().log(4, (Throwable)err, err.getMessage());
        }
        chain.doFilter(request, response);
    }

    private void checkConnection() throws SQLException, AdminException, SOAPException, IOException {
        if (connection == null) {
            connection = DQPConnection.getConnection((String)vdbName, (String)additionalProperties);
            this.initLogging(connection);
            connection.createStatement().execute(WARMUP_QUERY);
            this.platformLog.getLogFile().log(1, DataservicePlugin.Util.getString("DataServiceFilter.0"));
        }
    }

    public void destroy() {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                this.platformLog.getLogFile().log(1, DataservicePlugin.Util.getString("DataServiceFilter.3"));
            }
        }
        catch (SQLException err) {
            Object[] params = new Object[]{err};
            this.platformLog.getLogFile().log(4, (Throwable)err, DataservicePlugin.Util.getString("DataServiceFilter.2", params));
        }
        this.platformLog.getLogFile().log(1, DataservicePlugin.Util.getString("DataServiceFilter.1"));
    }

    private void initLogging(java.sql.Connection connection) throws SQLException, AdminException, IOException {
        Logger logger = Logger.getLogger((String)this.getClass().getName());
        logger.removeAllAppenders();
        BasicConfigurator.configure((Appender)new FileAppender((Layout)new PatternLayout("%d{MMM dd, yyyy HH:mm:ss.SSS} [%t|0] %p <%c|0> %m%n"), this.logWriter.getFilePathAndName()));
        logger.setLevel(Level.ERROR);
        EmbeddedAdmin admin = (EmbeddedAdmin)((Connection)connection).getAdminAPI();
        admin.setLogListener((EmbeddedLogger)this.dqpLoggerAdapter);
    }
}

