/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.net;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketHelper {
    private static String SSL_ENABLED = "metamatrix.encryption.secure.sockets";
    private static String KEYSTORE_FILENAME = "com.metamatrix.ssl.keystore.filename";
    private static String KEYSTORE_PASSWORD = "com.metamatrix.ssl.keystore.Password";
    private static String KEYSTORE_TYPE = "com.metamatrix.ssl.keystoretype";
    private static String SSL_PROTOCOL = "com.metamatrix.ssl.protocol";
    private static String KEY_MANAGER_ALGORITHM = "com.metamatrix.ssl.keymanagementalgorithm";
    private static String TRUSTSTORE_FILENAME = "com.metamatrix.ssl.truststore.filename";
    private static String TRUSTSTORE_PASSWORD = "com.metamatrix.ssl.truststore.Password";
    private static String CLIENT_AUTH = "com.metamatrix.ssl.clientAuthentication";
    private static String DEFAULT_SSL_PROTOCOL = "SSLv3";
    private static String DEFAULT_KEY_MANAGER_ALGORITHM = "SunX509";
    private static String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static boolean initialized = false;
    private static boolean client_ssl_enabled = false;
    private static String client_sslProtocol;
    private static String client_keyManagerFactoryAlgorithm;
    private static String client_keyStoreType;
    private static String client_keyStoreFileName;
    private static boolean server_ssl_enabled;
    private static String server_sslProtocol;
    private static String server_keyManagerFactoryAlgorithm;
    private static String server_keyStoreType;
    private static String server_keyStoreFileName;
    private static String server_trustStoreFileName;
    private static boolean server_client_auth_req;

    public static Socket getClientSocket(InetAddress bindAddr, int port) throws Exception {
        SocketHelper.initProperties();
        if (!client_ssl_enabled) {
            return new Socket(bindAddr, port);
        }
        Socket server = null;
        try {
            SSLContext context = SSLContext.getInstance((String)client_sslProtocol);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)client_keyManagerFactoryAlgorithm);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)client_keyManagerFactoryAlgorithm);
            KeyStore ks = KeyStore.getInstance(client_keyStoreType);
            char[] password = SocketHelper.getKeyStorePassword();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(client_keyStoreFileName);
            ks.load(is, password);
            kmf.init(ks, password);
            tmf.init(ks);
            context.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory factory = context.getSocketFactory();
            server = factory.createSocket(bindAddr, port);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw e2;
        }
        return server;
    }

    public static ServerSocket getServerSocket(int port, int backlog, InetAddress bindAddr) throws Exception {
        SocketHelper.initProperties();
        if (!server_ssl_enabled) {
            return new ServerSocket(port, backlog, bindAddr);
        }
        SSLServerSocket serverSocket = null;
        try {
            InputStream is;
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextInt();
            TrustManager[] trustManagers = null;
            if (server_client_auth_req) {
                KeyStore serverTrustStore = KeyStore.getInstance(server_keyStoreType);
                char[] ts_password = SocketHelper.getTrustStorePassword();
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(server_trustStoreFileName);
                serverTrustStore.load(is, ts_password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)server_keyManagerFactoryAlgorithm);
                tmf.init(serverTrustStore);
                trustManagers = tmf.getTrustManagers();
            }
            KeyStore serverKeyStore = KeyStore.getInstance(server_keyStoreType);
            char[] ks_password = SocketHelper.getKeyStorePassword();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(server_keyStoreFileName);
            serverKeyStore.load(is, ks_password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)server_keyManagerFactoryAlgorithm);
            kmf.init(serverKeyStore, ks_password);
            SSLContext context = SSLContext.getInstance((String)server_sslProtocol);
            context.init(kmf.getKeyManagers(), trustManagers, secureRandom);
            SSLServerSocketFactory factory = context.getServerSocketFactory();
            serverSocket = (SSLServerSocket)factory.createServerSocket(port, 50, bindAddr);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw e2;
        }
        serverSocket.setNeedClientAuth(server_client_auth_req);
        return serverSocket;
    }

    private static char[] getKeyStorePassword() throws Exception {
        Properties env = CurrentConfiguration.getResourceProperties((String)"SSL");
        return CryptoUtil.stringDecrypt((char[])env.getProperty(KEYSTORE_PASSWORD).toCharArray());
    }

    private static char[] getTrustStorePassword() throws Exception {
        Properties env = CurrentConfiguration.getResourceProperties((String)"SSL");
        return CryptoUtil.stringDecrypt((char[])env.getProperty(TRUSTSTORE_PASSWORD).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initProperties() throws Exception {
        if (!initialized) {
            String client_val = CurrentConfiguration.getProperty((String)SSL_ENABLED);
            client_ssl_enabled = client_val != null && client_val.equalsIgnoreCase("true");
            try {
                Properties clientProps = CurrentConfiguration.getResourceProperties((String)"SSL");
                client_keyStoreFileName = clientProps.getProperty(KEYSTORE_FILENAME);
                client_keyStoreType = clientProps.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
                client_sslProtocol = clientProps.getProperty(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL);
                client_keyManagerFactoryAlgorithm = clientProps.getProperty(KEY_MANAGER_ALGORITHM, DEFAULT_KEY_MANAGER_ALGORITHM);
            }
            catch (ConfigurationException ce) {
                client_keyStoreType = DEFAULT_KEYSTORE_TYPE;
                client_sslProtocol = DEFAULT_SSL_PROTOCOL;
                client_keyManagerFactoryAlgorithm = DEFAULT_KEY_MANAGER_ALGORITHM;
            }
            String server_val = CurrentConfiguration.getProperty((String)SSL_ENABLED);
            server_ssl_enabled = server_val != null && server_val.equalsIgnoreCase("true");
            try {
                Properties serverProps = CurrentConfiguration.getResourceProperties((String)"SSL");
                server_trustStoreFileName = serverProps.getProperty(TRUSTSTORE_FILENAME);
                String st_client_auth = serverProps.getProperty(CLIENT_AUTH);
                server_client_auth_req = st_client_auth != null && st_client_auth.equalsIgnoreCase("true");
                server_keyStoreFileName = serverProps.getProperty(KEYSTORE_FILENAME);
                server_keyStoreType = serverProps.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
                server_sslProtocol = serverProps.getProperty(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL);
                server_keyManagerFactoryAlgorithm = serverProps.getProperty(KEY_MANAGER_ALGORITHM, DEFAULT_KEY_MANAGER_ALGORITHM);
            }
            catch (ConfigurationException ce) {
                server_keyStoreType = client_keyStoreType;
                server_sslProtocol = client_sslProtocol;
                server_keyManagerFactoryAlgorithm = client_keyManagerFactoryAlgorithm;
            }
            finally {
                initialized = true;
            }
        }
    }

    static {
        server_ssl_enabled = false;
        server_client_auth_req = false;
    }
}

