/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import java.io.Serializable;
import java.sql.Time;
import java.util.Iterator;
import java.util.List;

public class OracleSQLConversionVisitor
extends SQLConversionVisitor {
    private final int MAX_SELECT_ALIAS_LENGTH = 30;
    private final int MAX_TABLE_ALIAS_LENGTH = 30;
    protected static final String DUAL = "DUAL";
    protected static final String ROWNUM = "ROWNUM";
    protected static final String SEQUENCE = ":SEQUENCE=";
    protected static final String HINT_PREFIX = "/*+";
    protected static final String ROWNUM_ALIAS = "MM_ROWNUM";
    protected static final String INLINE_VIEW_ALIAS = "MM_VIEW_FOR_LIMIT";
    private static final String DATE_TYPE = "DATE";

    protected void visitSelect(ISelect obj) {
        String payloadString;
        this.buffer.append("SELECT").append(" ");
        Serializable payload = this.getExecutionContext().getExecutionPayload();
        if (payload instanceof String && (payloadString = (String)((Object)payload)).startsWith(HINT_PREFIX)) {
            this.buffer.append(payloadString).append(" ");
        }
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getSelectSymbols());
    }

    protected boolean useAsInGroupAlias() {
        return false;
    }

    protected String replaceElementName(String group, String element) {
        String elementTrueName = this.getElementTrueName(element);
        if (elementTrueName != null) {
            return group + "." + elementTrueName;
        }
        if (group != null && group.equalsIgnoreCase(DUAL) || element.equalsIgnoreCase(ROWNUM)) {
            return element;
        }
        return null;
    }

    private String getElementTrueName(String element) {
        int useIndex = element.indexOf(SEQUENCE);
        if (useIndex >= 0) {
            return element.substring(0, useIndex);
        }
        return null;
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{ts'1970-01-01 " + this.formatDateValue(timeValue) + "'}";
    }

    public void visit(ICompareCriteria obj) {
        IExpression leftExpression = obj.getLeftExpression();
        this.append((ILanguageObject)leftExpression);
        this.buffer.append(" ");
        int op = obj.getOperator();
        switch (op) {
            case 0: {
                this.buffer.append("=");
                break;
            }
            case 5: {
                this.buffer.append(">=");
                break;
            }
            case 4: {
                this.buffer.append(">");
                break;
            }
            case 3: {
                this.buffer.append("<=");
                break;
            }
            case 2: {
                this.buffer.append("<");
                break;
            }
            case 1: {
                this.buffer.append("<>");
            }
        }
        this.buffer.append(" ");
        IExpression rightExpression = obj.getRightExpression();
        if (leftExpression instanceof IElement && rightExpression instanceof ILiteral && ((ILiteral)rightExpression).getType().equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP) && ((ILiteral)rightExpression).getValue() != null) {
            this.translateStringToTimestampConversion(leftExpression, rightExpression);
        } else {
            this.append((ILanguageObject)rightExpression);
        }
    }

    public void visit(IInsert obj) {
        Iterator iter = obj.getElements().iterator();
        for (int i = 0; i < obj.getElements().size(); ++i) {
            String sequence;
            int delimiterIndex;
            String name;
            String upperName;
            int index;
            IElement element = (IElement)iter.next();
            MetadataID metadataID = element.getMetadataID();
            if (metadataID == null || (index = (upperName = (name = this.getName(metadataID)).toUpperCase()).indexOf(SEQUENCE)) < 0 || (delimiterIndex = (sequence = name.substring(index + SEQUENCE.length())).indexOf(".")) < 0) continue;
            String sequenceGroupName = sequence.substring(0, delimiterIndex);
            String sequenceElementName = sequence.substring(delimiterIndex + 1);
            ILanguageObject previousValue = (ILanguageObject)obj.getValues().get(i);
            IGroup sequenceGroup = this.getLanguageFactory().createGroup(sequenceGroupName, null, null);
            IElement sequenceElement = this.getLanguageFactory().createElement(sequenceElementName, sequenceGroup, null, previousValue.getClass());
            obj.getValues().set(i, sequenceElement);
        }
        super.visit(obj);
    }

    protected void translateStringToTimestampConversion(IExpression leftExpression, IExpression rightExpression) {
        String nativeType = DATE_TYPE;
        try {
            IElement element = (IElement)leftExpression;
            MetadataID metadataID = element.getMetadataID();
            Element elem = (Element)this.metadata.getObject(metadataID);
            nativeType = elem.getNativeType();
        }
        catch (ConnectorException e) {
            // empty catch block
        }
        ILiteral timestamp = (ILiteral)rightExpression;
        if (nativeType != null && nativeType.equalsIgnoreCase(DATE_TYPE)) {
            this.buffer.append("to_date('");
            String tsValue = this.formatDateValue(timestamp.getValue());
            int decimalIndex = tsValue.lastIndexOf(".");
            if (decimalIndex >= 0) {
                this.buffer.append(tsValue.substring(0, decimalIndex));
            } else {
                this.buffer.append(tsValue);
            }
            this.buffer.append("','YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.buffer.append("to_timestamp('");
            this.buffer.append(this.formatDateValue(timestamp.getValue()));
            this.buffer.append("','YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    public void visit(ILimit obj) {
    }

    protected void appendQuery(IQuery obj) {
        ILimit limit = obj.getLimit();
        if (limit != null) {
            this.buffer.append("SELECT").append(" ").append("*").append(" ").append("FROM").append(" ").append("(").append("SELECT").append(" ").append(INLINE_VIEW_ALIAS).append(".").append("*").append(",").append(" ").append(ROWNUM).append(" ").append(ROWNUM_ALIAS).append(" ").append("FROM").append(" ").append("(");
        }
        super.appendQuery(obj);
        if (limit != null) {
            this.buffer.append(")").append(" ").append(INLINE_VIEW_ALIAS).append(")").append(" ").append("WHERE").append(" ").append(ROWNUM_ALIAS).append(" ");
            if (limit.getRowOffset() > 0) {
                this.buffer.append(">").append(" ").append(limit.getRowOffset());
            }
            if (limit.getRowLimit() > 0) {
                if (limit.getRowOffset() > 0) {
                    this.buffer.append(" ").append("AND").append(" ").append(ROWNUM_ALIAS).append(" ");
                }
                this.buffer.append("<=").append(" ").append(limit.getRowLimit() + limit.getRowOffset());
            }
        }
    }

    public void visit(IUnion obj) {
        this.appendQuery((IQuery)obj);
        List firstQuerySelectSymbols = obj.getSelect().getSelectSymbols();
        Iterator queryIter = obj.getUnionQueries().iterator();
        Iterator allIter = obj.getUnionAllFlags().iterator();
        while (queryIter.hasNext()) {
            this.buffer.append(" ");
            this.buffer.append("UNION");
            Boolean allFlag = (Boolean)allIter.next();
            if (allFlag.equals(Boolean.TRUE)) {
                this.buffer.append(" ");
                this.buffer.append("ALL");
            }
            this.buffer.append(" ");
            IQuery query = (IQuery)queryIter.next();
            if (obj.getUnionQueries().size() > 1) {
                List nextQuerySelectSymbols = query.getSelect().getSelectSymbols();
                for (int j = 0; j < firstQuerySelectSymbols.size(); ++j) {
                    ISelectSymbol targetSymbol = (ISelectSymbol)firstQuerySelectSymbols.get(j);
                    ISelectSymbol sourceSymbol = (ISelectSymbol)nextQuerySelectSymbols.get(j);
                    if (targetSymbol.getOutputName().equals(sourceSymbol.getOutputName())) continue;
                    String alias = null;
                    alias = targetSymbol.hasAlias() ? targetSymbol.getOutputName() : this.getShortName(targetSymbol.getOutputName());
                    sourceSymbol.setAlias(true);
                    sourceSymbol.setOutputName(alias);
                }
            }
            if (query instanceof IUnion) {
                this.buffer.append("(");
                this.append((ILanguageObject)query);
                this.buffer.append(")");
                continue;
            }
            this.appendQuery(query);
        }
        IOrderBy orderBy = obj.getUnionOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.appendUnionOrderBy(orderBy);
        }
    }

    protected void appendUnionOrderBy(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        List items = obj.getItems();
        Iterator iter = items.iterator();
        IOrderByItem item = (IOrderByItem)iter.next();
        this.appendUnionOrderByItem(item);
        while (iter.hasNext()) {
            this.buffer.append(",");
            this.buffer.append(" ");
            this.appendUnionOrderByItem((IOrderByItem)iter.next());
        }
    }

    protected void appendUnionOrderByItem(IOrderByItem obj) {
        String elementTrueName;
        IElement element;
        String itemName = obj.getName();
        if (obj.getElement() != null && (element = obj.getElement()).getMetadataID() != null && (elementTrueName = this.getElementTrueName(itemName = this.getName(element.getMetadataID()))) != null) {
            itemName = elementTrueName;
        }
        this.buffer.append(this.getShortName(itemName));
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    protected int getMaxSelectAliasLength() {
        return 30;
    }

    protected int getMaxTableAliasLength() {
        return 30;
    }
}

